/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.GraphContextImpl;
import org.jboss.windup.graph.GraphTypeManager;

public class GraphContextFactoryImpl
implements GraphContextFactory {
    private GraphApiCompositeClassLoaderProvider graphApiCompositeClassLoaderProvider;
    private Furnace furnace = SimpleContainer.getFurnace((ClassLoader)GraphContextFactory.class.getClassLoader());
    private GraphTypeManager graphTypeManager;

    public GraphContextFactoryImpl() throws Exception {
        this.graphApiCompositeClassLoaderProvider = (GraphApiCompositeClassLoaderProvider)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(GraphApiCompositeClassLoaderProvider.class).get();
        this.graphTypeManager = (GraphTypeManager)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(GraphTypeManager.class).get();
    }

    public GraphContext create() {
        return new GraphContextImpl(this.furnace, this.graphTypeManager, this.graphApiCompositeClassLoaderProvider, this.getTempGraphDirectory()).create();
    }

    public GraphContext create(Path graphDir) {
        return new GraphContextImpl(this.furnace, this.graphTypeManager, this.graphApiCompositeClassLoaderProvider, graphDir).create();
    }

    public GraphContext load(Path graphDir) {
        return new GraphContextImpl(this.furnace, this.graphTypeManager, this.graphApiCompositeClassLoaderProvider, graphDir).load();
    }

    private Path getTempGraphDirectory() {
        return new File(FileUtils.getTempDirectory(), "windupgraph_" + RandomStringUtils.randomAlphanumeric((int)6)).toPath();
    }
}

