/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.profile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.jboss.windup.graph.clz.ProfileClz;
import org.jboss.windup.graph.profile.Profile;

public abstract class AbstractProfile
implements Profile {
    private int version;
    private String name;
    protected Set<ProfileClz> classSet = new HashSet<ProfileClz>();
    protected Set<Profile> subProfiles = new HashSet<Profile>();

    public AbstractProfile(String classSet, String name, int version, String location) {
        this(name, version, location);
        this.loadProfile(classSet);
    }

    public AbstractProfile(String name, int version, String location) {
        this.name = name;
        this.version = version;
    }

    @Override
    public boolean doesProvide(String clz) {
        if (this.classSet.contains(clz)) {
            return true;
        }
        if (this.subProfiles != null) {
            for (Profile subProfile : this.subProfiles) {
                if (!subProfile.doesProvide(clz)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<ProfileClz> getProvided() {
        HashSet<ProfileClz> provided = new HashSet<ProfileClz>();
        provided.addAll(this.classSet);
        if (this.subProfiles != null) {
            for (Profile sub : this.subProfiles) {
                provided.addAll(sub.getProvided());
            }
        }
        return provided;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addSubProfile(Profile profile) {
        this.subProfiles.add(profile);
    }

    @Override
    public String getModuleIdentifier() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String resourceFile) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("profiles/" + resourceFile);
            GZIPInputStream gis = new GZIPInputStream(is);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            while (s != null) {
                this.classSet.add(new ProfileClz(s, this));
                s = br.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public boolean included(boolean allProfiles, Set<String> profileSet) {
        return allProfiles || profileSet != null && (profileSet.contains(this.getProfileCode()) || profileSet.contains(this.getProfileName()));
    }

    public abstract String getProfileCode();

    protected abstract String getProfileName();
}

