/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.decoration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.jboss.windup.metadata.decoration.Classification;
import org.jboss.windup.metadata.decoration.Global;
import org.jboss.windup.metadata.decoration.Hash;
import org.jboss.windup.metadata.decoration.JavaLine;
import org.jboss.windup.metadata.decoration.Line;
import org.jboss.windup.metadata.decoration.Link;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.decoration.hint.Hint;

@XmlRootElement(name="decorator-result")
@XmlSeeAlso(value={Classification.class, Global.class, Hash.class, JavaLine.class, Line.class, Link.class, Summary.class})
public abstract class AbstractDecoration
implements Comparable<AbstractDecoration> {
    protected final Map<String, Object> context = new HashMap<String, Object>();
    protected Effort effort = new UnknownEffort();
    protected Set<Hint> hints = new HashSet<Hint>();
    protected String description;
    protected NotificationLevel level = NotificationLevel.WARNING;
    protected String pattern;

    public Map<String, Object> getContext() {
        return this.context;
    }

    public Set<Hint> getHints() {
        return this.hints;
    }

    public void setHints(Set<Hint> hints) {
        this.hints = hints;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NotificationLevel getLevel() {
        return this.level;
    }

    public void setLevel(NotificationLevel level) {
        this.level = level;
    }

    public void setEffort(Effort effort) {
        this.effort = effort;
    }

    public Effort getEffort() {
        return this.effort;
    }

    @Override
    public int compareTo(AbstractDecoration dr) {
        if (this.equals(dr)) {
            return 0;
        }
        if (this.getDescription() == null) {
            return -1;
        }
        if (dr.getDescription() == null) {
            return 1;
        }
        int compare = this.getDescription().compareToIgnoreCase(dr.getDescription());
        if (compare != 0) {
            return compare;
        }
        return 1;
    }

    public static enum NotificationLevel {
        INFO(0),
        WARNING(1),
        SEVERE(2),
        CRITICAL(3);

        private final int level;

        private NotificationLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isLevel(NotificationLevel test) {
            return this.getLevel() >= test.getLevel();
        }
    }
}

