/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.decoration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class Interrogation
implements Comparable<Interrogation> {
    private String summary = "";
    private String title = null;
    private int order = 0;
    private final File result;
    private final File archiveDirectory;
    private final File reportDirectory;

    public Interrogation(File result, File reportDirectory, File archiveDirectory) {
        this.result = result;
        this.reportDirectory = reportDirectory;
        this.archiveDirectory = archiveDirectory;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getOrder() {
        return this.order;
    }

    public File getResult() {
        return this.result;
    }

    @Override
    public int compareTo(Interrogation o) {
        return this.order - o.getOrder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archiveDirectory == null ? 0 : this.archiveDirectory.hashCode());
        result = 31 * result + this.order;
        result = 31 * result + (this.reportDirectory == null ? 0 : this.reportDirectory.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interrogation other = (Interrogation)obj;
        if (this.archiveDirectory == null ? other.archiveDirectory != null : !this.archiveDirectory.equals(other.archiveDirectory)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.reportDirectory == null ? other.reportDirectory != null : !this.reportDirectory.equals(other.reportDirectory)) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        if (this.summary == null ? other.summary != null : !this.summary.equals(other.summary)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public String getTitle() {
        if (StringUtils.isBlank((String)this.title)) {
            return this.getArchiveRelativePath();
        }
        return this.title;
    }

    public String getLink() {
        return this.getReportRelativePath();
    }

    protected String getArchiveRelativePath() {
        String basePath = this.archiveDirectory.getAbsolutePath();
        String finalRelative = StringUtils.removeStart((String)this.result.getAbsolutePath(), (String)basePath);
        finalRelative = StringUtils.replace((String)finalRelative, (String)"\\", (String)"/");
        finalRelative = StringUtils.replace((String)finalRelative, (String)"//", (String)"/");
        finalRelative = StringUtils.removeStart((String)finalRelative, (String)"/");
        return finalRelative;
    }

    protected String getReportRelativePath() {
        String basePath = this.reportDirectory.getAbsolutePath();
        String finalRelative = StringUtils.removeStart((String)this.result.getAbsolutePath(), (String)basePath);
        finalRelative = StringUtils.replace((String)finalRelative, (String)"\\", (String)"/");
        finalRelative = StringUtils.replace((String)finalRelative, (String)"//", (String)"/");
        finalRelative = StringUtils.removeStart((String)finalRelative, (String)"/");
        return finalRelative;
    }

    public void renderHtml(BufferedWriter bw, boolean oddRow) throws IOException {
        bw.append("<tr ");
        bw.append("class='" + (oddRow ? "rowodd" : "roweven") + "'");
        bw.append(">");
        if (this.result != null) {
            bw.append("<td><a href='" + this.getReportRelativePath() + "'>" + this.getTitle() + "</a></td>");
            bw.append("<td>" + this.getSummary() + "</td>");
        } else {
            bw.append("<td>" + this.getTitle() + "</td>");
            bw.append("<td>" + this.getSummary() + "</td>");
        }
        bw.append("</tr>");
    }
}

