/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.metadata.type;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;

public class ZipEntryMetadata
extends FileMetadata {
    private static final int BUFFER = 2048;
    private static final Log LOG = LogFactory.getLog(ZipEntryMetadata.class);
    private ZipEntry zipEntry;

    @Override
    public File getFilePointer() {
        if (!(this.getArchiveMeta() instanceof ZipMetadata)) {
            throw new IllegalStateException("ZipEntryMetadata must be child of Zip.");
        }
        ZipMetadata parent = (ZipMetadata)this.getArchiveMeta();
        if (this.filePointer == null) {
            try {
                File archiveOutputDirectory = this.getArchiveMeta().getArchiveOutputDirectory();
                this.filePointer = this.unzipEntry(this.zipEntry, parent.getZipFile(), archiveOutputDirectory);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception unzipping entry: " + this.archiveMeta.getFilePointer().getAbsolutePath()), (Throwable)e);
            }
        }
        return this.filePointer;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.filePointer = null;
        this.zipEntry = zipEntry;
    }

    protected File unzipEntry(ZipEntry entry, ZipFile zipfile, File archiveOutputDirectory) throws IOException, FileNotFoundException {
        String pathOutput = null;
        pathOutput = StringUtils.contains((String)entry.toString(), (String)"/") ? StringUtils.substringBeforeLast((String)entry.toString(), (String)"/") : File.separator;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("PathOutput: " + pathOutput));
            LOG.trace((Object)("PathEntry: " + entry));
            LOG.trace((Object)("ArchiveOutput: " + archiveOutputDirectory.getAbsolutePath()));
        }
        File entryPathOutput = new File(archiveOutputDirectory.getAbsolutePath() + File.separator + pathOutput);
        File entryOutput = new File(archiveOutputDirectory.getAbsolutePath() + File.separator + entry);
        if (!entryOutput.exists()) {
            int count;
            FileUtils.forceMkdir((File)entryPathOutput);
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(entry));
            LOG.debug((Object)("Unzipping: " + entryOutput.getAbsolutePath()));
            byte[] data = new byte[2048];
            FileOutputStream fos = new FileOutputStream(entryOutput);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            while ((count = is.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
        }
        return entryOutput;
    }
}

