/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.arquillian;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.forge.arquillian.archive.AddonDeploymentArchive;
import org.jboss.forge.arquillian.spi.AddonDeploymentScenarioEnhancer;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;

public class WindupFurnaceAddonDeploymentEnhancer
implements AddonDeploymentScenarioEnhancer {
    public List<DeploymentDescription> enhance(TestClass testClass, List<DeploymentDescription> deployments) {
        String version;
        if (Boolean.getBoolean("maven.surefire.debug") && (version = this.getWindupVersion(deployments)) != null) {
            AddonId id = AddonId.from((String)"org.jboss.windup.rexster:windup-rexster", (String)version);
            AddonDeploymentArchive archive = ((AddonDeploymentArchive)ShrinkWrap.create(AddonDeploymentArchive.class)).setAddonId(id);
            archive.setDeploymentTimeoutUnit(TimeUnit.MILLISECONDS);
            archive.setDeploymentTimeoutQuantity(10000);
            DeploymentDescription deploymentDescription = new DeploymentDescription(id.toCoordinates(), (Archive)archive);
            deploymentDescription.shouldBeTestable(false);
            deployments.add(deploymentDescription);
        }
        return deployments;
    }

    private String getWindupVersion(List<DeploymentDescription> deployments) {
        HashMap<String, Integer> versionOccurences = new HashMap<String, Integer>();
        for (DeploymentDescription deployment : deployments) {
            if (!deployment.toString().contains("windup")) continue;
            String version = deployment.toString().split(",")[1];
            if (deployment.toString().contains("windup-config")) {
                return version;
            }
            if (versionOccurences.containsKey(deployment.toString().split(",")[1])) {
                versionOccurences.put(version, (Integer)versionOccurences.get(version) + 1);
                continue;
            }
            versionOccurences.put(version, 1);
        }
        Map.Entry maxEntry = null;
        for (Map.Entry stringIntegerEntry : versionOccurences.entrySet()) {
            if (maxEntry != null && (Integer)stringIntegerEntry.getValue() <= (Integer)maxEntry.getValue()) continue;
            maxEntry = stringIntegerEntry;
        }
        return maxEntry == null ? null : (String)maxEntry.getKey();
    }
}

