/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.wise.gui.CleanupHelper;
import org.jboss.wise.gui.CleanupTask;

public class CleanupTask<T> {
    private TreeMap<Long, Holder<T>> refs = new TreeMap();

    public CleanupTask(boolean register) {
        if (register) {
            CleanupHelper.addTask((CleanupTask)this);
        }
    }

    public synchronized void addRef(T obj, long expTimeMillis, CleanupCallback<T> cb) {
        this.refs.put(expTimeMillis, new Holder(cb, obj));
    }

    public synchronized void refsCleanup() {
        long curTime = System.currentTimeMillis();
        boolean done = false;
        Iterator it = this.refs.entrySet().iterator();
        while (it.hasNext() && !done) {
            Map.Entry entry = it.next();
            if (curTime > (Long)entry.getKey()) {
                Holder h = (Holder)entry.getValue();
                h.getCallback().cleanup(h.getData());
                it.remove();
                continue;
            }
            done = true;
        }
    }

    public synchronized void refsCleanupNoChecks() {
        Iterator it = this.refs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Holder h = (Holder)entry.getValue();
            h.getCallback().cleanup(h.getData());
            it.remove();
        }
    }

    public synchronized void removeRef(T obj) {
        boolean done = false;
        Holder r = new Holder(obj);
        Iterator it = this.refs.entrySet().iterator();
        while (it.hasNext() && !done) {
            Map.Entry entry = it.next();
            Holder h = (Holder)entry.getValue();
            if (!h.equals((Object)r)) continue;
            it.remove();
            done = true;
        }
    }
}

