/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.ws.handler.Handler;
import org.jboss.logging.Logger;
import org.jboss.wise.core.client.BasicWSDynamicClient;
import org.jboss.wise.core.client.InvocationResult;
import org.jboss.wise.core.client.WSEndpoint;
import org.jboss.wise.core.client.WSMethod;
import org.jboss.wise.core.exception.InvocationException;
import org.jboss.wise.core.exception.WiseAuthenticationException;
import org.jboss.wise.core.exception.WiseProcessingException;
import org.jboss.wise.core.exception.WiseWebServiceException;
import org.jboss.wise.core.utils.JBossLoggingOutputStream;
import org.jboss.wise.gui.CleanupTask;
import org.jboss.wise.gui.ClientHelper;
import org.jboss.wise.gui.ResponseLogHandler;
import org.jboss.wise.gui.model.TreeNodeImpl;
import org.jboss.wise.gwt.shared.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Named
@ConversationScoped
public class ClientConversationBean
implements Serializable {
    private static final long serialVersionUID = -3778997821476776895L;
    private static final int CONVERSATION_TIMEOUT = 900000;
    private static CleanupTask<BasicWSDynamicClient> cleanupTask = new CleanupTask(true);
    private static Logger logger = Logger.getLogger(ClientConversationBean.class);
    protected static PrintStream ps = new PrintStream((OutputStream)new JBossLoggingOutputStream(logger, Logger.Level.DEBUG), true);
    @Inject
    Conversation conversation;
    protected BasicWSDynamicClient client;
    private String wsdlUrl;
    private String wsdlUser;
    private String wsdlPwd;
    private String invocationUrl;
    private String invocationUser;
    private String invocationPwd;
    private List<Service> services;
    private String currentOperation;
    private String currentOperationFullName;
    private TreeNodeImpl inputTree;
    private TreeNodeImpl outputTree;
    private String error;
    private String requestPreview;
    private String responseMessage;
    private String requestActiveTab;

    @PostConstruct
    public void init() {
        this.conversation.begin();
        this.conversation.setTimeout(900000L);
    }

    public void performInvocation() throws WiseWebServiceException, WiseProcessingException, WiseAuthenticationException {
        this.outputTree = null;
        this.error = null;
        this.responseMessage = null;
        ByteArrayOutputStream os = null;
        try {
            WSMethod wsMethod = ClientHelper.getWSMethod((String)this.currentOperation, (BasicWSDynamicClient)this.client);
            InvocationResult result = null;
            os = new ByteArrayOutputStream();
            Map params = ClientHelper.processGUIParameters((TreeNodeImpl)this.inputTree);
            ClientHelper.addOUTParameters((Map)params, (WSMethod)wsMethod, (BasicWSDynamicClient)this.client);
            WSEndpoint endpoint = wsMethod.getEndpoint();
            endpoint.setTargetUrl(this.invocationUrl);
            endpoint.setPassword(this.invocationPwd);
            endpoint.setUsername(this.invocationUser);
            endpoint.addHandler((Handler)new ResponseLogHandler((OutputStream)os));
            result = wsMethod.invoke((Object)params);
            if (result != null) {
                this.outputTree = ClientHelper.convertOperationResultToGui((InvocationResult)result, (BasicWSDynamicClient)this.client);
                this.error = null;
            }
        }
        catch (InvocationException ie) {
            ClientConversationBean.logException((Exception)((Object)ie));
            this.error = "Unexpected fault / error received from target endpoint";
            throw new WiseProcessingException(ClientHelper.toErrorMessage((Exception)((Object)ie)), (Throwable)ie);
        }
        catch (WiseWebServiceException wwse) {
            if (wwse.getMessage().contains("Authentication exception")) {
                throw new WiseAuthenticationException();
            }
            this.error = wwse.getCause().toString();
        }
        catch (Exception e) {
            this.error = ClientHelper.toErrorMessage((Exception)e);
            ClientConversationBean.logException((Exception)e);
            throw new WiseProcessingException(ClientHelper.toErrorMessage((Exception)e), e.getCause());
        }
        finally {
            try {
                this.responseMessage = os.toString("UTF-8");
            }
            catch (UnsupportedEncodingException wwse) {}
            if (this.responseMessage.trim().length() == 0) {
                this.responseMessage = null;
            }
        }
    }

    public void generateRequestPreview() {
        this.requestPreview = null;
        try {
            WSMethod wsMethod = ClientHelper.getWSMethod((String)this.currentOperation, (BasicWSDynamicClient)this.client);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            wsMethod.getEndpoint().setTargetUrl(null);
            wsMethod.writeRequestPreview(ClientHelper.processGUIParameters((TreeNodeImpl)this.inputTree), (OutputStream)os);
            this.requestPreview = os.toString("UTF-8");
        }
        catch (Exception e) {
            this.requestPreview = ClientHelper.toErrorMessage((Exception)e);
            ClientConversationBean.logException((Exception)e);
        }
    }

    protected void cleanup() {
        if (this.client != null) {
            cleanupTask.removeRef((Object)this.client);
            this.client.close();
            this.client = null;
        }
        this.services = null;
        this.currentOperation = null;
        this.currentOperationFullName = null;
        this.inputTree = null;
        this.outputTree = null;
        this.inputTree = null;
        this.error = null;
        this.responseMessage = null;
        this.invocationUrl = null;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public String getWsdlUser() {
        return this.wsdlUser;
    }

    public void setWsdlUser(String wsdlUser) {
        this.wsdlUser = wsdlUser != null && wsdlUser.length() == 0 ? null : wsdlUser;
    }

    public String getWsdlPwd() {
        return this.wsdlPwd;
    }

    public void setWsdlPwd(String wsdlPwd) {
        this.wsdlPwd = wsdlPwd != null && wsdlPwd.length() == 0 ? null : wsdlPwd;
    }

    public String getInvocationUrl() {
        return this.invocationUrl;
    }

    public void setInvocationUrl(String invocationUrl) {
        this.invocationUrl = invocationUrl != null && invocationUrl.length() == 0 ? null : invocationUrl;
    }

    public String getInvocationUser() {
        return this.invocationUser;
    }

    public void setInvocationUser(String invocationUser) {
        this.invocationUser = invocationUser != null && invocationUser.length() == 0 ? null : invocationUser;
    }

    public String getInvocationPwd() {
        return this.invocationPwd;
    }

    public void setInvocationPwd(String invocationPwd) {
        this.invocationPwd = invocationPwd != null && invocationPwd.length() == 0 ? null : invocationPwd;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public String getCurrentOperation() {
        return this.currentOperation;
    }

    public String getCurrentOperationFullName() {
        return this.currentOperationFullName;
    }

    public void setCurrentOperationFullName(String currentOperationFullName) {
        this.currentOperationFullName = currentOperationFullName;
    }

    public void setCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
    }

    public TreeNodeImpl getInputTree() {
        return this.inputTree;
    }

    public void setInputTree(TreeNodeImpl inputTree) {
        this.inputTree = inputTree;
    }

    public TreeNodeImpl getOutputTree() {
        return this.outputTree;
    }

    public void setOutputTree(TreeNodeImpl outputTree) {
        this.outputTree = outputTree;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getRequestPreview() {
        return this.requestPreview;
    }

    public void setRequestPreview(String requestPreview) {
        this.requestPreview = requestPreview;
    }

    public String getRequestActiveTab() {
        return this.requestActiveTab;
    }

    public void setRequestActiveTab(String requestActiveTab) {
        this.requestActiveTab = requestActiveTab;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    protected static void logException(Exception e) {
        logger.error((Object)"", (Throwable)e);
    }
}

