/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import org.jboss.wise.core.client.BasicWSDynamicClient;
import org.jboss.wise.core.client.InvocationResult;
import org.jboss.wise.core.client.WSEndpoint;
import org.jboss.wise.core.client.WSMethod;
import org.jboss.wise.core.client.WSService;
import org.jboss.wise.core.client.WebParameter;
import org.jboss.wise.core.exception.ResourceNotAvailableException;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.model.TreeNodeImpl;
import org.jboss.wise.gui.treeElement.WiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElementBuilder;
import org.jboss.wise.gwt.shared.Operation;
import org.jboss.wise.gwt.shared.Port;
import org.jboss.wise.gwt.shared.Service;

public class ClientHelper
implements Serializable {
    private static final long serialVersionUID = 4838483183941121581L;

    public static WSMethod getWSMethod(String currentOperation, BasicWSDynamicClient client) throws ResourceNotAvailableException {
        StringTokenizer st = new StringTokenizer(currentOperation, ";");
        String serviceName = st.nextToken();
        String portName = st.nextToken();
        String operationName = st.nextToken();
        return client.getWSMethod(serviceName, portName, operationName);
    }

    public static TreeNodeImpl convertOperationParametersToGui(WSMethod wsMethod, BasicWSDynamicClient client) {
        WiseTreeElementBuilder builder = new WiseTreeElementBuilder(client, true);
        TreeNodeImpl rootElement = new TreeNodeImpl();
        Collection parameters = wsMethod.getWebParams().values();
        SOAPBinding soapBindingAnn = wsMethod.getEndpoint().getUnderlyingObjectClass().getAnnotation(SOAPBinding.class);
        boolean rpcLit = false;
        if (soapBindingAnn != null) {
            SOAPBinding.Style style = soapBindingAnn.style();
            rpcLit = style != null && SOAPBinding.Style.RPC.equals((Object)style);
        }
        for (WebParameter parameter : parameters) {
            if (parameter.getMode() == WebParam.Mode.OUT) continue;
            WiseTreeElement wte = builder.buildTreeFromType(parameter.getType(), parameter.getName(), null, !rpcLit);
            rootElement.addChild(wte.getId(), (TreeNode)wte);
        }
        return rootElement;
    }

    public static TreeNodeImpl convertOperationResultToGui(InvocationResult result, BasicWSDynamicClient client) {
        String key;
        WiseTreeElementBuilder builder = new WiseTreeElementBuilder(client, false);
        TreeNodeImpl rootElement = new TreeNodeImpl();
        HashMap<String, Type> resTypes = new HashMap<String, Type>();
        for (Map.Entry res : result.getResult().entrySet()) {
            key = (String)res.getKey();
            if (!key.startsWith("type.")) continue;
            resTypes.put(key, (Type)res.getValue());
        }
        for (Map.Entry res : result.getResult().entrySet()) {
            Type type;
            key = (String)res.getKey();
            if (key.startsWith("type.") || (type = (Type)resTypes.get("type." + key)) == Void.TYPE || type == Void.class) continue;
            WiseTreeElement wte = builder.buildTreeFromType(type, key, res.getValue(), true);
            rootElement.addChild(wte.getId(), (TreeNode)wte);
        }
        return rootElement;
    }

    public static List<Service> convertServicesToGui(Map<String, WSService> servicesMap) {
        LinkedList<Service> services = new LinkedList<Service>();
        for (Map.Entry<String, WSService> serviceEntry : servicesMap.entrySet()) {
            Service service = new Service();
            services.add(service);
            service.setName(serviceEntry.getKey());
            LinkedList<Port> ports = new LinkedList<Port>();
            service.setPorts(ports);
            for (Map.Entry endpointEntry : serviceEntry.getValue().processEndpoints().entrySet()) {
                Port port = new Port();
                port.setName((String)endpointEntry.getKey());
                ports.add(port);
                LinkedList<Operation> operations = new LinkedList<Operation>();
                port.setOperations(operations);
                for (Map.Entry methodEntry : ((WSEndpoint)endpointEntry.getValue()).getWSMethods().entrySet()) {
                    Operation operation = new Operation();
                    operation.setId(operation.hashCode());
                    operation.setName((String)methodEntry.getKey());
                    StringBuilder sb = new StringBuilder();
                    sb.append((String)methodEntry.getKey());
                    sb.append("(");
                    Iterator paramIt = ((WSMethod)methodEntry.getValue()).getWebParams().values().iterator();
                    while (paramIt.hasNext()) {
                        WebParameter param = (WebParameter)paramIt.next();
                        Type type = param.getType();
                        String typeString = type instanceof Class ? ((Class)type).getSimpleName() : type.toString();
                        sb.append(typeString);
                        sb.append(" ");
                        sb.append(param.getName());
                        if (!paramIt.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(")");
                    operation.setFullName(sb.toString());
                    operations.add(operation);
                    operation.setCurrentOperation(service.getName() + ";" + port.getName() + ";" + operation.getName());
                }
            }
        }
        return services;
    }

    public static String getFirstGuiOperation(List<Service> services) {
        if (services == null) {
            return null;
        }
        for (Service s : services) {
            for (Port p : s.getPorts()) {
                Iterator iterator = p.getOperations().iterator();
                if (!iterator.hasNext()) continue;
                Operation o = (Operation)iterator.next();
                StringBuilder sb = new StringBuilder();
                sb.append(s.getName());
                sb.append(";");
                sb.append(p.getName());
                sb.append(";");
                sb.append(o.getName());
                return sb.toString();
            }
        }
        return null;
    }

    public static String getOperationFullName(String currentGuiOperation, List<Service> services) {
        if (currentGuiOperation == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(currentGuiOperation, ";");
        String serviceName = st.nextToken();
        String portName = st.nextToken();
        String operationName = st.nextToken();
        for (Service s : services) {
            if (!serviceName.equals(s.getName())) continue;
            for (Port p : s.getPorts()) {
                if (!portName.equals(p.getName())) continue;
                for (Operation o : p.getOperations()) {
                    if (!operationName.equals(o.getName())) continue;
                    return o.getFullName();
                }
            }
        }
        return null;
    }

    public static Map<String, Object> processGUIParameters(TreeNodeImpl inputTree) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator it = inputTree.getChildrenKeysIterator();
        while (it.hasNext()) {
            WiseTreeElement wte = (WiseTreeElement)inputTree.getChild(it.next());
            params.put(wte.getName(), wte.toObject());
        }
        return params;
    }

    public static void addOUTParameters(Map<String, Object> params, WSMethod wsMethod, BasicWSDynamicClient client) {
        WiseTreeElementBuilder builder = null;
        Collection parameters = wsMethod.getWebParams().values();
        for (WebParameter parameter : parameters) {
            if (parameter.getMode() != WebParam.Mode.OUT) continue;
            if (builder == null) {
                builder = new WiseTreeElementBuilder(client, true);
            }
            WiseTreeElement wte = builder.buildTreeFromType(parameter.getType(), parameter.getName(), null, true);
            params.put(wte.getName(), wte.isNil() ? null : wte.toObject());
        }
    }

    public static String toErrorMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        if (e instanceof WiseRuntimeException) {
            sb.append(e.getMessage());
        } else {
            sb.append(e.toString());
        }
        if (e.getCause() != null) {
            sb.append(", caused by ");
            sb.append(e.getCause());
        }
        return sb.toString();
    }
}

