/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;

public class ResponseLogHandler
implements LogicalHandler<LogicalMessageContext> {
    private final OutputStream outputStream;

    public ResponseLogHandler(OutputStream outStream) {
        this.outputStream = outStream;
    }

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public boolean handleMessage(LogicalMessageContext smc) {
        this.doLog(smc);
        return true;
    }

    public boolean handleFault(LogicalMessageContext smc) {
        this.doLog(smc);
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private void doLog(LogicalMessageContext smc) {
        if (!((Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            try {
                TransformerFactory tff = TransformerFactory.newInstance();
                Transformer tf = tff.newTransformer();
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                Source sc = smc.getMessage().getPayload();
                StreamResult result = new StreamResult(this.outputStream);
                tf.transform(sc, result);
            }
            catch (Exception e) {
                PrintWriter ps = new PrintWriter(this.outputStream);
                ps.println("Exception getting response message log: ");
                e.printStackTrace(ps);
            }
        }
    }
}

