/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.model;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.wise.gui.model.TreeNode;

public class TreeNodeImpl
implements TreeNode {
    private List<Object> keysList = null;
    private Map<Object, TreeNode> children = null;
    private boolean leaf;

    public TreeNodeImpl() {
        this(false);
    }

    public TreeNodeImpl(boolean leaf) {
        this.leaf = leaf;
        if (!leaf) {
            this.keysList = Lists.newArrayList();
            this.children = Maps.newHashMap();
        }
    }

    public void addChild(Object key, TreeNode child) {
        if (this.isLeaf()) {
            throw new IllegalStateException("Cannot add children to leaf");
        }
        this.keysList.add(key);
        this.children.put(key, child);
    }

    public void insertChild(int idx, Object key, TreeNode child) {
        if (this.isLeaf()) {
            throw new IllegalStateException("Cannot add children to leaf");
        }
        this.keysList.add(idx, key);
        this.children.put(key, child);
    }

    public void removeChild(Object key) {
        if (this.isLeaf()) {
            return;
        }
        this.children.remove(key);
        this.keysList.remove(key);
    }

    public TreeNode getChild(Object key) {
        if (this.isLeaf()) {
            return null;
        }
        return (TreeNode)this.children.get(key);
    }

    public Iterator<Object> getChildrenKeysIterator() {
        if (this.isLeaf()) {
            return Collections.emptyIterator();
        }
        return Iterators.unmodifiableIterator(this.keysList.iterator());
    }

    public int indexOf(Object key) {
        if (this.isLeaf()) {
            return -1;
        }
        return this.keysList.indexOf(key);
    }

    public boolean isLeaf() {
        return this.leaf;
    }
}

