/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import javax.xml.bind.DatatypeConverter;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class ByteArrayWiseTreeElement
extends SimpleWiseTreeElement {
    private static final long serialVersionUID = 1L;

    public ByteArrayWiseTreeElement() {
        this.kind = "byteArray";
    }

    public ByteArrayWiseTreeElement(Class<?> classType, String name, String value) {
        this.kind = "byteArray";
        this.classType = classType;
        this.nil = value == null;
        this.name = name;
        this.value = value;
    }

    public WiseTreeElement clone() {
        ByteArrayWiseTreeElement element = new ByteArrayWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setValue(this.value);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        return element;
    }

    public void parseObject(Object obj) {
        if (obj != null) {
            this.setValue(DatatypeConverter.printBase64Binary((byte[])((byte[])obj)));
        } else {
            this.setValue(null);
        }
        this.nil = obj == null && this.nillable;
    }

    public Object toObject() {
        if (this.isNil()) {
            return null;
        }
        Object result = null;
        if (this.value != null) {
            return DatatypeConverter.parseBase64Binary((String)this.value);
        }
        return result;
    }
}

