/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.core.utils.ReflectionUtils;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.treeElement.GroupWiseTreeElement;
import org.jboss.wise.gui.treeElement.IDGenerator;
import org.jboss.wise.gui.treeElement.ParameterizedWiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class ComplexWiseTreeElement
extends WiseTreeElement {
    private static final long serialVersionUID = 1L;

    private ComplexWiseTreeElement() {
        this.kind = "complex";
        this.id = IDGenerator.nextVal();
        this.expanded = true;
    }

    public ComplexWiseTreeElement(Type classType, String name) {
        this();
        this.classType = classType;
        this.nil = false;
        this.name = name;
    }

    public WiseTreeElement clone() {
        ComplexWiseTreeElement element = new ComplexWiseTreeElement();
        Iterator keyIt = this.getChildrenKeysIterator();
        while (keyIt.hasNext()) {
            WiseTreeElement child = (WiseTreeElement)this.getChild(keyIt.next());
            element.addChild(child.getId(), (TreeNode)child.clone());
        }
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        return element;
    }

    public Object toObject() {
        if (this.isNil()) {
            return null;
        }
        Object obj = null;
        try {
            Class cl = (Class)this.classType;
            obj = cl.newInstance();
            Iterator keyIt = this.getChildrenKeysIterator();
            while (keyIt.hasNext()) {
                Method method;
                WiseTreeElement child = (WiseTreeElement)this.getChild(keyIt.next());
                String setter = ReflectionUtils.setterMethodName((String)child.getName(), (boolean)child.isTypeBoolean());
                String getter = ReflectionUtils.getterMethodName((String)child.getName(), (boolean)child.isTypeBoolean());
                if (child instanceof GroupWiseTreeElement) {
                    method = cl.getMethod(getter, null);
                    Collection col = (Collection)method.invoke(obj, (Object[])null);
                    col.addAll((List)child.toObject());
                    continue;
                }
                Object childObject = child.toObject();
                if (child instanceof ParameterizedWiseTreeElement) {
                    method = cl.getMethod(setter, (Class)((ParameterizedType)child.getClassType()).getRawType());
                } else {
                    if (childObject == null) continue;
                    Class fieldClass = (Class)child.getClassType();
                    method = Duration.class.isAssignableFrom(fieldClass) ? cl.getMethod(setter, Duration.class) : (XMLGregorianCalendar.class.isAssignableFrom(fieldClass) ? cl.getMethod(setter, XMLGregorianCalendar.class) : cl.getMethod(setter, fieldClass));
                }
                method.invoke(obj, childObject);
            }
        }
        catch (Exception e) {
            throw new WiseRuntimeException("Error converting element to object", (Throwable)e);
        }
        return obj;
    }
}

