/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class DurationWiseTreeElement
extends SimpleWiseTreeElement {
    private static final long serialVersionUID = 5492389675960954725L;

    public DurationWiseTreeElement() {
        this.kind = "Duration";
    }

    public DurationWiseTreeElement(Class<?> classType, String name, String value) {
        this.kind = "Duration";
        this.classType = classType;
        this.nil = value == null;
        this.name = name;
        this.value = value;
    }

    public WiseTreeElement clone() {
        DurationWiseTreeElement element = new DurationWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setValue(this.value);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        return element;
    }

    public void parseObject(Object obj) {
        this.setValue(obj != null ? ((Duration)obj).toString() : null);
        this.nil = obj == null && this.nillable;
    }

    public void enforceNotNillable() {
        this.nillable = false;
        this.nil = false;
        this.value = "0";
    }

    public Object toObject() {
        if (this.isNil()) {
            return null;
        }
        Duration result = null;
        try {
            result = DatatypeFactory.newInstance().newDuration(Long.parseLong(this.value));
        }
        catch (DatatypeConfigurationException e) {
            throw new WiseRuntimeException("Error converting element to object, type format error?", (Throwable)e);
        }
        return result;
    }
}

