/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class EnumerationWiseTreeElement
extends SimpleWiseTreeElement {
    private static final long serialVersionUID = 5492389675960954725L;

    public EnumerationWiseTreeElement() {
        this.kind = "Enumeration";
    }

    public EnumerationWiseTreeElement(Class<?> classType, String name, String value) {
        this.kind = "Enumeration";
        this.classType = classType;
        this.nil = value == null;
        this.name = name;
        this.value = value;
    }

    public WiseTreeElement clone() {
        EnumerationWiseTreeElement element = new EnumerationWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setValue(this.value);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        return element;
    }

    public void enforceNotNillable() {
        this.nillable = false;
        this.nil = false;
        this.value = (String)this.getValidValue().keySet().iterator().next();
    }

    public void parseObject(Object obj) {
        if (obj != null) {
            try {
                Method method = obj.getClass().getMethod("value", new Class[0]);
                this.value = (String)method.invoke(obj, new Object[0]);
                this.nil = this.value == null;
            }
            catch (Exception e) {
                throw new WiseRuntimeException("Type format error", (Throwable)e);
            }
        } else {
            this.setValue(null);
        }
    }

    public Map<String, String> getValidValue() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (Object obj : ((Class)this.classType).getEnumConstants()) {
            try {
                Method method = obj.getClass().getMethod("value", new Class[0]);
                String valueOfEnum = (String)method.invoke(obj, new Object[0]);
                returnMap.put(valueOfEnum, valueOfEnum);
            }
            catch (Exception e) {
                throw new WiseRuntimeException("Type format error", (Throwable)e);
            }
        }
        return returnMap;
    }

    public Object toObject() {
        Class cl = (Class)this.classType;
        try {
            if (this.isNil()) {
                return null;
            }
            Method method = cl.getMethod("fromValue", String.class);
            Object obj = method.invoke(null, this.value);
            return obj;
        }
        catch (Exception e) {
            throw new WiseRuntimeException("Type format error", (Throwable)e);
        }
    }
}

