/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.treeElement.IDGenerator;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class GroupWiseTreeElement
extends WiseTreeElement {
    private static final long serialVersionUID = 1L;
    private WiseTreeElement prototype;

    private GroupWiseTreeElement() {
        this.kind = "group";
        this.id = IDGenerator.nextVal();
        this.expanded = true;
    }

    public GroupWiseTreeElement(Type classType, String name, WiseTreeElement prototype) {
        this();
        this.classType = classType;
        this.nil = false;
        this.name = name;
        this.prototype = prototype;
    }

    public WiseTreeElement getPrototype() {
        return this.prototype;
    }

    public void setPrototype(WiseTreeElement prototype) {
        this.prototype = prototype;
    }

    public WiseTreeElement clone() {
        GroupWiseTreeElement element = new GroupWiseTreeElement();
        Iterator keyIt = this.getChildrenKeysIterator();
        while (keyIt.hasNext()) {
            WiseTreeElement child = (WiseTreeElement)this.getChild(keyIt.next());
            element.addChild(child.getId(), (TreeNode)child.clone());
        }
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        if (this.prototype != null) {
            element.setPrototype(this.prototype.clone());
        }
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        return element;
    }

    public WiseTreeElement incrementChildren() {
        WiseTreeElement component = this.prototype.clone();
        component.setRemovable(true);
        this.addChild(component.getId(), (TreeNode)component);
        return component;
    }

    public Object toObject() {
        if (this.isNil()) {
            return null;
        }
        LinkedList<Object> returnList = new LinkedList<Object>();
        Iterator keyIt = this.getChildrenKeysIterator();
        while (keyIt.hasNext()) {
            WiseTreeElement child = (WiseTreeElement)this.getChild(keyIt.next());
            returnList.add(child.toObject());
        }
        return returnList;
    }

    public String getType() {
        return ((Class)((ParameterizedType)this.classType).getActualTypeArguments()[0]).getSimpleName();
    }

    public int getSize() {
        Iterator keyIt = this.getChildrenKeysIterator();
        int i = 0;
        while (keyIt.hasNext()) {
            ++i;
            keyIt.next();
        }
        return i;
    }
}

