/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.treeElement.IDGenerator;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class LazyLoadWiseTreeElement
extends WiseTreeElement {
    private static final long serialVersionUID = 1L;
    private boolean resolved = false;
    protected Map<Type, WiseTreeElement> treeTypesMap;

    private LazyLoadWiseTreeElement() {
        this.kind = "lazy";
        this.id = IDGenerator.nextVal();
    }

    public LazyLoadWiseTreeElement(Type classType, String name, Map<Type, WiseTreeElement> treeTypesMap) {
        this.kind = "lazy";
        this.id = IDGenerator.nextVal();
        this.classType = classType;
        this.nil = false;
        this.name = name;
        this.treeTypesMap = treeTypesMap;
    }

    public WiseTreeElement clone() {
        LazyLoadWiseTreeElement element = new LazyLoadWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        element.setResolved(false);
        element.setTreeTypesMap(this.treeTypesMap);
        return element;
    }

    public void resolveReference() {
        if (!this.isResolved()) {
            WiseTreeElement ref = (WiseTreeElement)this.treeTypesMap.get(this.classType);
            WiseTreeElement component = ref.clone();
            component.setName(this.getName());
            this.addChild(component.getId(), (TreeNode)component);
            this.setResolved(true);
        }
    }

    public Object toObject() {
        Iterator keyIt = this.getChildrenKeysIterator();
        return keyIt.hasNext() ? ((WiseTreeElement)this.getChild(keyIt.next())).toObject() : null;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public Map<Type, WiseTreeElement> getTreeTypesMap() {
        return this.treeTypesMap;
    }

    public void setTreeTypesMap(Map<Type, WiseTreeElement> treeTypesMap) {
        this.treeTypesMap = treeTypesMap;
    }
}

