/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.ws.Holder;
import org.jboss.wise.core.client.BasicWSDynamicClient;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.treeElement.IDGenerator;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class ParameterizedWiseTreeElement
extends WiseTreeElement {
    private static final long serialVersionUID = 5492389675960954725L;
    private BasicWSDynamicClient client;
    private Class<?> scope;
    private String namespace;
    private Class<?> parameterizedClass;

    public ParameterizedWiseTreeElement() {
        this.kind = "Parameterized";
        this.id = IDGenerator.nextVal();
        this.expanded = true;
    }

    public ParameterizedWiseTreeElement(ParameterizedType classType, Class<?> parameterizedClass, String name, BasicWSDynamicClient client, Class<?> scope, String namespace) {
        this();
        this.classType = classType;
        this.nil = false;
        this.name = name;
        this.client = client;
        this.scope = scope;
        this.namespace = namespace;
        this.parameterizedClass = parameterizedClass;
    }

    public WiseTreeElement clone() {
        ParameterizedWiseTreeElement element = new ParameterizedWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        element.setClient(this.client);
        element.setScope(this.scope);
        element.setNamespace(this.namespace);
        element.setParameterizedClass(this.parameterizedClass);
        Iterator keyIt = this.getChildrenKeysIterator();
        while (keyIt.hasNext()) {
            WiseTreeElement child = (WiseTreeElement)this.getChild(keyIt.next());
            element.addChild(child.getId(), (TreeNode)child.clone());
        }
        return element;
    }

    public Object toObject() throws WiseRuntimeException {
        if (this.isLeaf()) {
            return null;
        }
        Object child = ((WiseTreeElement)this.getChild(this.getChildrenKeysIterator().next())).toObject();
        if (this.parameterizedClass.isAssignableFrom(JAXBElement.class)) {
            return this.instanceXmlElementDecl(this.name, this.scope, this.namespace, child);
        }
        if (this.parameterizedClass.isAssignableFrom(Holder.class)) {
            return this.instanceHolder(child);
        }
        throw new WiseRuntimeException("Unsupported parameterized class: " + this.parameterizedClass);
    }

    private Object instanceHolder(Object obj) {
        return new Holder(obj);
    }

    private Object instanceXmlElementDecl(String name, Class<?> scope, String namespace, Object value) {
        try {
            Class objectFactoryClass = null;
            Method methodToUse = null;
            boolean done = false;
            List objectFactories = this.client.getObjectFactories();
            if (objectFactories != null) {
                Iterator it = objectFactories.iterator();
                while (it.hasNext() && !done) {
                    objectFactoryClass = (Class)it.next();
                    Method[] methods = objectFactoryClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        XmlElementDecl annotation = methods[i].getAnnotation(XmlElementDecl.class);
                        if (annotation == null || !name.equals(annotation.name()) || annotation.namespace() != null && !annotation.namespace().equals(namespace) || annotation.scope() != null && !annotation.scope().equals(scope)) continue;
                        methodToUse = methods[i];
                        break;
                    }
                    if (methodToUse == null) continue;
                    done = true;
                }
            }
            if (methodToUse != null) {
                Object obj = objectFactoryClass.newInstance();
                return methodToUse.invoke(obj, value);
            }
            return null;
        }
        catch (Exception e) {
            throw new WiseRuntimeException((Throwable)e);
        }
    }

    public void setClient(BasicWSDynamicClient client) {
        this.client = client;
    }

    public void setScope(Class<?> scope) {
        this.scope = scope;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Class<?> getParameterizedClass() {
        return this.parameterizedClass;
    }

    public void setParameterizedClass(Class<?> parameterizedClass) {
        this.parameterizedClass = parameterizedClass;
    }
}

