/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import javax.xml.bind.DatatypeConverter;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.core.utils.JavaUtils;
import org.jboss.wise.gui.treeElement.IDGenerator;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleWiseTreeElement
extends WiseTreeElement {
    private static final long serialVersionUID = 1L;
    protected String value;

    public SimpleWiseTreeElement() {
        super(true);
        this.kind = "simple";
        this.id = IDGenerator.nextVal();
    }

    public SimpleWiseTreeElement(Class<?> classType, String name, String value) {
        super(true);
        this.kind = "simple";
        this.id = IDGenerator.nextVal();
        this.classType = classType;
        this.name = name;
        this.init(classType, value);
    }

    public String getValue() {
        return this.value;
    }

    public String getShortValue() {
        if (this.getValue() == null) {
            return null;
        }
        if (this.getValue().length() <= 60) {
            return this.getValue();
        }
        return this.getValue().substring(0, 60) + "...";
    }

    public String getLongValue() {
        if (this.getValue() == null) {
            return null;
        }
        try {
            String base64String = DatatypeConverter.printBase64Binary((byte[])this.getValue().getBytes());
            return URLEncoder.encode(base64String, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WiseRuntimeException((Throwable)e);
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public WiseTreeElement clone() {
        SimpleWiseTreeElement element = new SimpleWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        element.init((Class)this.classType, null);
        return element;
    }

    public void parseObject(Object obj) {
        this.setValue(obj == null ? null : obj.toString());
        this.nil = obj == null && this.nillable;
    }

    public void enforceNotNillable() {
        this.nillable = false;
        this.nil = false;
        this.value = SimpleWiseTreeElement.getDefaultValue((Class)((Class)this.classType));
    }

    private void init(Class<?> classType, String value) {
        this.value = value == null && classType.isPrimitive() ? SimpleWiseTreeElement.getDefaultValue(classType) : value;
        this.nillable = !classType.isPrimitive();
        this.nil = value == null && this.nillable;
    }

    private static String getDefaultValue(Class<?> cl) {
        if (cl.isPrimitive()) {
            cl = JavaUtils.getWrapperType(cl);
        }
        if ("java.lang.String".equalsIgnoreCase(cl.getName())) {
            return "";
        }
        if ("java.lang.Boolean".equalsIgnoreCase(cl.getName())) {
            return "false";
        }
        if ("java.lang.Byte".equalsIgnoreCase(cl.getName())) {
            return "0";
        }
        if ("java.lang.Character".equalsIgnoreCase(cl.getName())) {
            return "";
        }
        if ("java.lang.Double".equalsIgnoreCase(cl.getName())) {
            return "0.0";
        }
        if ("java.lang.Float".equalsIgnoreCase(cl.getName())) {
            return "0.0";
        }
        if ("java.lang.Integer".equalsIgnoreCase(cl.getName())) {
            return "0";
        }
        if ("java.lang.Long".equalsIgnoreCase(cl.getName())) {
            return "0";
        }
        if ("java.lang.Short".equalsIgnoreCase(cl.getName())) {
            return "0";
        }
        if ("java.math.BigDecimal".equalsIgnoreCase(cl.getName())) {
            return "0.0";
        }
        if ("java.math.BigInteger".equalsIgnoreCase(cl.getName())) {
            return "0";
        }
        if ("java.lang.Object".equalsIgnoreCase(cl.getName())) {
            return "";
        }
        throw new WiseRuntimeException("Class type not supported: " + cl);
    }

    public Object toObject() {
        if (this.isNil()) {
            return null;
        }
        if (!this.isNillable() && this.value == null) {
            this.value = "";
        }
        if (this.value == null) {
            return null;
        }
        Class cl = (Class)this.classType;
        if (cl.isPrimitive()) {
            cl = JavaUtils.getWrapperType((Class)cl);
        }
        if ("java.lang.String".equalsIgnoreCase(cl.getName())) {
            return new String(this.value);
        }
        if ("java.lang.Boolean".equalsIgnoreCase(cl.getName())) {
            return new Boolean(this.value);
        }
        if ("java.lang.Byte".equalsIgnoreCase(cl.getName())) {
            return new Byte(this.value);
        }
        if ("java.lang.Character".equalsIgnoreCase(cl.getName())) {
            return new Character(this.value.charAt(0));
        }
        if ("java.lang.Double".equalsIgnoreCase(cl.getName())) {
            return new Double(this.value);
        }
        if ("java.lang.Float".equalsIgnoreCase(cl.getName())) {
            return new Float(this.value);
        }
        if ("java.lang.Integer".equalsIgnoreCase(cl.getName())) {
            return new Integer(this.value);
        }
        if ("java.lang.Long".equalsIgnoreCase(cl.getName())) {
            return new Long(this.value);
        }
        if ("java.lang.Short".equalsIgnoreCase(cl.getName())) {
            return new Short(this.value);
        }
        if ("java.math.BigDecimal".equalsIgnoreCase(cl.getName())) {
            return BigDecimal.valueOf(Double.parseDouble(this.value));
        }
        if ("java.math.BigInteger".equalsIgnoreCase(cl.getName())) {
            return BigInteger.valueOf(Long.parseLong(this.value));
        }
        if ("java.lang.Object".equalsIgnoreCase(cl.getName())) {
            return this.value;
        }
        throw new WiseRuntimeException("Class type not supported: " + cl);
    }
}

