/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.model.TreeNodeImpl;

public abstract class WiseTreeElement
extends TreeNodeImpl
implements TreeNode,
Serializable,
Cloneable {
    private static final long serialVersionUID = 5298756163814063425L;
    public static final String SIMPLE = "simple";
    public static final String BYTE_ARRAY = "byteArray";
    public static final String COMPLEX = "complex";
    public static final String DURATION = "Duration";
    public static final String ENUMERATION = "Enumeration";
    public static final String GROUP = "group";
    public static final String LAZY = "lazy";
    public static final String PARAMETERIZED = "Parameterized";
    public static final String QNAME = "qname";
    public static final String ROOT = "root";
    public static final String XML_GREGORIAN_CAL = "XMLGregorianCalendar";
    protected Object id;
    protected String name;
    protected String kind;
    protected boolean expanded = false;
    protected boolean nil;
    protected boolean nillable = true;
    private boolean removable = false;
    private WiseTreeElement parent;
    protected Type classType;

    protected WiseTreeElement() {
    }

    protected WiseTreeElement(boolean isLeaf) {
        super(isLeaf);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public Type getClassType() {
        return this.classType;
    }

    public boolean isTypeBoolean() {
        return "Boolean".equalsIgnoreCase(this.getType());
    }

    public void setClassType(Type classType) {
        this.classType = classType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNil() {
        return this.nil;
    }

    public void setNil(boolean nil) {
        this.nil = nil;
    }

    public Object getId() {
        return this.id;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNotNillable() {
        return !this.isNillable();
    }

    public boolean isNotNil() {
        return !this.isNil();
    }

    public void setNotNil(boolean notNil) {
        this.setNil(!notNil);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getType() {
        if (this.classType instanceof ParameterizedType) {
            return ((Class)((ParameterizedType)this.classType).getRawType()).getSimpleName();
        }
        return ((Class)this.classType).getSimpleName();
    }

    public WiseTreeElement getParent() {
        return this.parent;
    }

    public void setParent(WiseTreeElement parent) {
        this.parent = parent;
    }

    public void addChild(Object key, TreeNode child) {
        super.addChild(key, child);
        if (child instanceof WiseTreeElement) {
            ((WiseTreeElement)child).setParent(this);
        }
    }

    public void insertChild(int idx, Object key, TreeNode child) {
        super.insertChild(idx, key, child);
        if (child instanceof WiseTreeElement) {
            ((WiseTreeElement)child).setParent(this);
        }
    }

    public void removeChild(Object key) {
        TreeNode child = this.getChild(key);
        if (child instanceof WiseTreeElement) {
            ((WiseTreeElement)child).setParent(null);
        }
        super.removeChild(key);
    }

    public abstract WiseTreeElement clone();

    public abstract Object toObject();
}

