/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.ws.Holder;
import org.jboss.logging.Logger;
import org.jboss.wise.core.client.BasicWSDynamicClient;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.core.utils.ReflectionUtils;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.treeElement.ByteArrayWiseTreeElement;
import org.jboss.wise.gui.treeElement.ComplexWiseTreeElement;
import org.jboss.wise.gui.treeElement.GroupWiseTreeElement;
import org.jboss.wise.gui.treeElement.IDGenerator;
import org.jboss.wise.gui.treeElement.LazyLoadWiseTreeElement;
import org.jboss.wise.gui.treeElement.ParameterizedWiseTreeElement;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElement;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElementFactory;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

/*
 * Exception performing whole class analysis ignored.
 */
public class WiseTreeElementBuilder {
    private static Logger logger = Logger.getLogger(WiseTreeElementBuilder.class);
    private final BasicWSDynamicClient client;
    private final boolean request;
    private final boolean trace;

    public WiseTreeElementBuilder(BasicWSDynamicClient client, boolean request) {
        this.client = client;
        this.request = request;
        this.trace = logger.isTraceEnabled();
    }

    public WiseTreeElement buildTreeFromType(Type type, String name, Object value, boolean nillable) {
        return this.buildTreeFromType(type, name, value, nillable, null, null, new HashMap(), new HashSet());
    }

    private WiseTreeElement buildTreeFromType(Type type, String name, Object obj, boolean nillable, Class<?> scope, String namespace, Map<Type, WiseTreeElement> typeMap, Set<Type> stack) {
        if (this.trace) {
            logger.trace((Object)("=> Converting parameter '" + name + "', type '" + type + "'"));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return this.buildParameterizedType(pt, name, obj, scope, namespace, typeMap, stack);
        }
        return this.buildFromClass((Class)type, name, obj, nillable, typeMap, stack);
    }

    private WiseTreeElement buildParameterizedType(ParameterizedType pt, String name, Object obj, Class<?> scope, String namespace, Map<Type, WiseTreeElement> typeMap, Set<Type> stack) {
        Type firstTypeArg = pt.getActualTypeArguments()[0];
        if (Collection.class.isAssignableFrom((Class)pt.getRawType())) {
            GroupWiseTreeElement group;
            if (obj != null || this.request) {
                WiseTreeElement prototype = this.buildTreeFromType(firstTypeArg, name, null, true, null, null, typeMap, stack);
                group = new GroupWiseTreeElement((Type)pt, name, prototype);
                if (obj != null) {
                    for (Object o : (Collection)obj) {
                        group.addChild((Object)IDGenerator.nextVal(), (TreeNode)this.buildTreeFromType(firstTypeArg, name, o, true, null, null, typeMap, stack));
                    }
                }
            } else {
                group = new GroupWiseTreeElement((Type)pt, name, null);
            }
            return group;
        }
        if (obj != null && obj instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        } else if (obj != null && obj instanceof Holder) {
            obj = ((Holder)obj).value;
        }
        WiseTreeElement element = this.buildTreeFromType(firstTypeArg, name, obj, true, null, null, typeMap, stack);
        ParameterizedWiseTreeElement parameterized = new ParameterizedWiseTreeElement(pt, (Class)pt.getRawType(), name, this.client, scope, namespace);
        parameterized.addChild(element.getId(), (TreeNode)element);
        return parameterized;
    }

    private WiseTreeElement buildFromClass(Class<?> cl, String name, Object obj, boolean nillable, Map<Type, WiseTreeElement> typeMap, Set<Type> stack) {
        if (cl.isArray()) {
            if (this.trace) {
                logger.trace((Object)("* array, component type: " + cl.getComponentType()));
            }
            if (Byte.TYPE.equals(cl.getComponentType())) {
                ByteArrayWiseTreeElement element = new ByteArrayWiseTreeElement(cl, name, null);
                if (obj != null) {
                    element.parseObject(obj);
                }
                return element;
            }
            throw new WiseRuntimeException("Converter doesn't support this Object[] yet.");
        }
        if (WiseTreeElementBuilder.isSimpleType(cl, (BasicWSDynamicClient)this.client)) {
            if (this.trace) {
                logger.trace((Object)"* simple");
            }
            SimpleWiseTreeElement element = SimpleWiseTreeElementFactory.create(cl, (String)name, (Object)obj);
            if (!nillable) {
                element.enforceNotNillable();
            }
            return element;
        }
        if (this.request && stack.contains(cl)) {
            if (this.trace) {
                logger.trace((Object)"* lazy");
            }
            return new LazyLoadWiseTreeElement(cl, name, typeMap);
        }
        if (this.trace) {
            logger.trace((Object)"* complex");
        }
        ComplexWiseTreeElement complex = new ComplexWiseTreeElement(cl, name);
        if (this.request) {
            stack.add(cl);
        }
        for (Field field : ReflectionUtils.getAllFields(cl)) {
            XmlElement elemAnnotation = field.getAnnotation(XmlElement.class);
            XmlElementRef refAnnotation = field.getAnnotation(XmlElementRef.class);
            String fieldName = null;
            String namespace = null;
            if (elemAnnotation != null && !elemAnnotation.name().startsWith("#")) {
                fieldName = elemAnnotation.name();
            }
            if (refAnnotation != null) {
                fieldName = refAnnotation.name();
                namespace = refAnnotation.namespace();
            }
            String xmlName = fieldName;
            if (fieldName == null) {
                fieldName = field.getName();
            }
            Object fieldValue = null;
            if (obj != null) {
                try {
                    Method getter = cl.getMethod(ReflectionUtils.getGetter((Field)field, (String)xmlName), null);
                    fieldValue = getter.invoke(obj, (Object[])null);
                }
                catch (Exception e) {
                    throw new WiseRuntimeException("Error calling getter method for field " + field, (Throwable)e);
                }
            }
            WiseTreeElement element = this.buildTreeFromType(field.getGenericType(), fieldName, fieldValue, true, cl, namespace, typeMap, stack);
            complex.addChild(element.getId(), (TreeNode)element);
        }
        if (this.request) {
            stack.remove(cl);
            typeMap.put(cl, complex.clone());
        }
        if (!nillable) {
            complex.setNillable(false);
        }
        return complex;
    }

    private static boolean isSimpleType(Class<?> cl, BasicWSDynamicClient client) {
        return cl.isEnum() || cl.isPrimitive() || client.getClassLoader() != cl.getClassLoader();
    }
}

