/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gui.treeElement;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.wise.core.exception.WiseRuntimeException;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElement;

public class XMLGregorianWiseTreeElement
extends SimpleWiseTreeElement {
    private static final long serialVersionUID = 5492389675960954725L;
    private Date valueDate;

    public XMLGregorianWiseTreeElement() {
        this.kind = "XMLGregorianCalendar";
    }

    public XMLGregorianWiseTreeElement(Class<?> classType, String name, String value) {
        this.kind = "XMLGregorianCalendar";
        this.classType = classType;
        this.nil = value == null;
        this.name = name;
        this.value = value;
    }

    public WiseTreeElement clone() {
        XMLGregorianWiseTreeElement element = new XMLGregorianWiseTreeElement();
        element.setName(this.name);
        element.setNil(this.nil);
        element.setClassType(this.classType);
        element.setValue(this.value);
        element.setRemovable(this.isRemovable());
        element.setNillable(this.isNillable());
        element.setValueDate(this.valueDate);
        return element;
    }

    public void parseObject(Object obj) {
        if (obj != null) {
            this.setValueDate(((XMLGregorianCalendar)obj).toGregorianCalendar().getTime());
            this.setValue(((XMLGregorianCalendar)obj).toString());
        } else {
            this.setValueDate(null);
            this.setValue(null);
        }
        this.nil = obj == null;
    }

    public void enforceNotNillable() {
        this.nillable = false;
        this.nil = false;
        this.value = new Date().toString();
    }

    public Object toObject() {
        XMLGregorianCalendar result = null;
        if (!this.isNil() && this.getValueDate() != null) {
            try {
                GregorianCalendar gregCal = new GregorianCalendar();
                gregCal.setTime(this.getValueDate());
                result = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregCal);
            }
            catch (DatatypeConfigurationException e) {
                throw new WiseRuntimeException("Type format error", (Throwable)e);
            }
        }
        return result;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }
}

