/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gwt.client.handlers;

import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;

public class URLFieldValidator
implements KeyPressHandler {
    private static RegExp urlValidator;
    private static RegExp urlPlusTldValidator;
    private TextBox textbox;
    private Label errorLabel;

    public URLFieldValidator(TextBox textbox, Label errorLabel) {
        this.textbox = textbox;
        this.errorLabel = errorLabel;
        if (urlValidator == null || urlPlusTldValidator == null) {
            urlValidator = RegExp.compile((String)"^((ftp|http|https)://[\\w@.\\-\\_]+(:\\d{1,5})?(/[\\w#!:.?+=&%@!\\_\\-/]+)*){1}$");
            urlPlusTldValidator = RegExp.compile((String)"^((ftp|http|https)://[\\w@.\\-\\_]+\\.[a-zA-Z]{2,}(:\\d{1,5})?(/[\\w#!:.?+=&%@!\\_\\-/]+)*){1}$");
        }
    }

    public void onKeyPress(KeyPressEvent event) {
        if (this.errorLabel.isVisible()) {
            TextBox eventSrc = (TextBox)event.getSource();
            if (event.getNativeEvent().getKeyCode() == 8 && eventSrc.getValue().length() - eventSrc.getSelectedText().length() <= 1) {
                this.textbox.removeStyleName("urlValidationError");
                this.errorLabel.setVisible(false);
            } else if (this.isValidUrl(this.textbox.getValue())) {
                this.textbox.removeStyleName("urlValidationError");
                this.errorLabel.setVisible(false);
            }
        }
    }

    public boolean urlFieldValidation() {
        boolean isValid = this.isValidUrl(this.textbox.getValue());
        if (!isValid && !this.errorLabel.isVisible()) {
            this.textbox.addStyleName("urlValidationError");
            this.errorLabel.setVisible(true);
        }
        return isValid;
    }

    public boolean isValidUrl(String url) {
        return urlValidator.exec(url) != null;
    }

    public boolean isValidUrl(String url, boolean topLevelDomainRequired) {
        return (topLevelDomainRequired ? urlPlusTldValidator : urlValidator).exec(url) != null;
    }
}

