/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gwt.client.presenter;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import org.jboss.wise.gwt.client.MainServiceAsync;
import org.jboss.wise.gwt.client.event.InvocationEvent;
import org.jboss.wise.gwt.client.event.LoginCancelEvent;
import org.jboss.wise.gwt.client.event.LoginEvent;
import org.jboss.wise.gwt.client.event.LoginRequestEvent;
import org.jboss.wise.gwt.client.event.ProcessingExceptionEvent;
import org.jboss.wise.gwt.client.presenter.EndpointConfigPresenter;
import org.jboss.wise.gwt.client.presenter.Presenter;
import org.jboss.wise.gwt.client.widget.CredentialDialogBox;
import org.jboss.wise.gwt.shared.WsdlInfo;
import org.jboss.wise.gwt.shared.tree.element.TreeElement;

public class EndpointConfigPresenter
implements Presenter {
    private final MainServiceAsync rpcService;
    private final HandlerManager eventBus;
    private final Display display;
    private boolean isLoginEvent = false;
    private WsdlInfo wsdlInfo = new WsdlInfo();
    private HandlerRegistration processingExceptionEventRegistration;
    private HandlerRegistration loginRequestEventRegistration;
    private HandlerRegistration loginEventRegistration;
    private HandlerRegistration loginCancelEventRegistration;
    private HandlerRegistration invokeButtonRegistration;
    private HandlerRegistration refreshPreviewMsgButtonRegistration;
    private HandlerRegistration backButtonRegistration;
    private HandlerRegistration openHandlerRegistration;
    private HandlerRegistration closeHandlerRegistration;

    public EndpointConfigPresenter(MainServiceAsync rpcService, HandlerManager eventBus, Display display) {
        this.rpcService = rpcService;
        this.eventBus = eventBus;
        this.display = display;
        this.bind();
    }

    public EndpointConfigPresenter(MainServiceAsync rpcService, HandlerManager eventBus, Display display, String id) {
        this.rpcService = rpcService;
        this.eventBus = eventBus;
        this.display = display;
        this.bind();
        rpcService.getEndpointReflection(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void bind() {
        this.processingExceptionEventRegistration = this.eventBus.addHandler(ProcessingExceptionEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.loginRequestEventRegistration = this.eventBus.addHandler(LoginRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.loginEventRegistration = this.eventBus.addHandler(LoginEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.loginCancelEventRegistration = this.eventBus.addHandler(LoginCancelEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.invokeButtonRegistration = this.display.getInvokeButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshPreviewMsgButtonRegistration = this.display.getRefreshPreviewMsgButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.backButtonRegistration = this.display.getBackButton().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.openHandlerRegistration = this.display.getPreviewDisclosurePanel().addOpenHandler((OpenHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.closeHandlerRegistration = this.display.getPreviewDisclosurePanel().addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void unbind() {
        this.processingExceptionEventRegistration.removeHandler();
        this.loginRequestEventRegistration.removeHandler();
        this.loginEventRegistration.removeHandler();
        this.loginCancelEventRegistration.removeHandler();
        this.invokeButtonRegistration.removeHandler();
        this.refreshPreviewMsgButtonRegistration.removeHandler();
        this.backButtonRegistration.removeHandler();
        this.openHandlerRegistration.removeHandler();
        this.closeHandlerRegistration.removeHandler();
    }

    public void go(HasWidgets container) {
        container.clear();
        container.add(this.display.asWidget());
        if (this.isLoginEvent) {
            this.doLogin();
            this.isLoginEvent = false;
        } else {
            this.display.enableMenuButtons(true);
        }
    }

    private void doInvoke() {
        String otherServerURL = this.display.getOtherServerURL();
        if (otherServerURL.isEmpty()) {
            this.sendEvent();
        } else if (this.display.urlFieldValidation()) {
            this.sendEvent();
        }
    }

    private void sendEvent() {
        TreeElement pNode = this.display.getParamsConfig();
        this.wsdlInfo.setWsdl(this.display.getOtherServerURL());
        if (pNode == null) {
            Window.alert((String)"getParamsConfig returned NULL");
        } else {
            this.eventBus.fireEvent((GwtEvent)new InvocationEvent(pNode, this.wsdlInfo));
        }
    }

    private void doPreview() {
        TreeElement pNode = this.display.getParamsConfig();
        if (pNode == null) {
            Window.alert((String)"getParamsConfig returned NULL");
        } else {
            this.rpcService.getRequestPreview(pNode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void doLogin() {
        CredentialDialogBox cDialogBox = new CredentialDialogBox(this.rpcService, this.eventBus, this.wsdlInfo.getUser(), this.display.getParamsConfig());
        int left = Window.getClientWidth() / 4;
        int top = Window.getClientHeight() / 4;
        cDialogBox.setPopupPosition(left, top);
        cDialogBox.show();
    }

    static /* synthetic */ Display access$000(EndpointConfigPresenter x0) {
        return x0.display;
    }

    static /* synthetic */ boolean access$102(EndpointConfigPresenter x0, boolean x1) {
        x0.isLoginEvent = x1;
        return x0.isLoginEvent;
    }

    static /* synthetic */ WsdlInfo access$200(EndpointConfigPresenter x0) {
        return x0.wsdlInfo;
    }

    static /* synthetic */ void access$300(EndpointConfigPresenter x0) {
        x0.doInvoke();
    }

    static /* synthetic */ void access$400(EndpointConfigPresenter x0) {
        x0.doPreview();
    }

    static /* synthetic */ HandlerManager access$500(EndpointConfigPresenter x0) {
        return x0.eventBus;
    }

    static /* synthetic */ void access$600(EndpointConfigPresenter x0) {
        x0.unbind();
    }
}

