/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gwt.client.view;

import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.wise.gwt.client.presenter.EndpointsPresenter;
import org.jboss.wise.gwt.client.util.TreeImageResource;
import org.jboss.wise.gwt.client.widget.MenuPanel;
import org.jboss.wise.gwt.client.widget.StepLabel;
import org.jboss.wise.gwt.shared.Operation;
import org.jboss.wise.gwt.shared.Port;
import org.jboss.wise.gwt.shared.Service;

public class EndpointsView
extends Composite
implements EndpointsPresenter.Display {
    MenuPanel menuPanel = new MenuPanel();
    private Map<TreeItem, Operation> endpointsMap = new HashMap();
    @UiField(provided=true)
    private Tree rootNode;

    public EndpointsView() {
        SimplePanel contentDetailsDecorator = new SimplePanel();
        contentDetailsDecorator.setWidth("100%");
        contentDetailsDecorator.setWidth("640px");
        this.initWidget((Widget)contentDetailsDecorator);
        VerticalPanel contentDetailsPanel = new VerticalPanel();
        contentDetailsPanel.setWidth("100%");
        StepLabel stepTitle = new StepLabel("Step 1 of 3: Select an Endpoint");
        contentDetailsPanel.add((Widget)stepTitle);
        TreeImageResource resources = new TreeImageResource();
        this.rootNode = new Tree((Tree.Resources)resources);
        this.rootNode.addItem(new TreeItem(SafeHtmlUtils.fromString((String)"")));
        contentDetailsPanel.add((Widget)this.rootNode);
        this.menuPanel.getNextButton().setEnabled(false);
        contentDetailsPanel.add((Widget)this.menuPanel);
        contentDetailsDecorator.add((Widget)contentDetailsPanel);
    }

    public Tree getData() {
        return this.rootNode;
    }

    public String getId(TreeItem treeItem) {
        Operation o;
        if (treeItem != null && (o = (Operation)this.endpointsMap.get(treeItem)) != null) {
            return o.getCurrentOperation();
        }
        return null;
    }

    public HasClickHandlers getBackButton() {
        return this.menuPanel.getBackButton();
    }

    public Button getNextButton() {
        return this.menuPanel.getNextButton();
    }

    public Widget asWidget() {
        return this;
    }

    public void setData(List<Service> data) {
        this.endpointsMap.clear();
        this.rootNode.removeItems();
        if (data != null) {
            for (Service s : data) {
                TreeItem serviceItem = new TreeItem(SafeHtmlUtils.fromString((String)s.getName()));
                this.rootNode.addItem(serviceItem);
                for (Port p : s.getPorts()) {
                    TreeItem portItem = new TreeItem(SafeHtmlUtils.fromString((String)p.getName()));
                    serviceItem.addItem(portItem);
                    serviceItem.setState(true);
                    for (Operation o : p.getOperations()) {
                        TreeItem tItem = new TreeItem(SafeHtmlUtils.fromString((String)o.getFullName()));
                        portItem.addItem(tItem);
                        portItem.setState(true);
                        tItem.addStyleName("endpoint");
                        this.endpointsMap.put(tItem, o);
                    }
                }
            }
        }
    }
}

