/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gwt.client.view;

import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.wise.gwt.client.presenter.InvocationPresenter;
import org.jboss.wise.gwt.client.util.TreeImageResource;
import org.jboss.wise.gwt.client.view.EndpointConfigView;
import org.jboss.wise.gwt.client.widget.MenuPanel;
import org.jboss.wise.gwt.client.widget.MessageDisplayPanel;
import org.jboss.wise.gwt.client.widget.StepLabel;
import org.jboss.wise.gwt.shared.tree.element.ComplexTreeElement;
import org.jboss.wise.gwt.shared.tree.element.EnumerationTreeElement;
import org.jboss.wise.gwt.shared.tree.element.GroupTreeElement;
import org.jboss.wise.gwt.shared.tree.element.ParameterizedTreeElement;
import org.jboss.wise.gwt.shared.tree.element.RequestResponse;
import org.jboss.wise.gwt.shared.tree.element.SimpleTreeElement;
import org.jboss.wise.gwt.shared.tree.element.TreeElement;

public class InvocationView
extends Composite
implements InvocationPresenter.Display {
    MenuPanel menuPanel = new MenuPanel();
    @UiField(provided=true)
    private Tree rootNode = null;
    private String responseMessage;
    private MessageDisplayPanel previewMessageDisplayPanel = new MessageDisplayPanel("View Message");

    public InvocationView() {
        SimplePanel contentDetailsDecorator = new SimplePanel();
        contentDetailsDecorator.setWidth("100%");
        contentDetailsDecorator.setWidth("640px");
        this.initWidget((Widget)contentDetailsDecorator);
        VerticalPanel contentDetailsPanel = new VerticalPanel();
        contentDetailsPanel.setWidth("100%");
        StepLabel stepTitle = new StepLabel("Step 3 of 3: Result Data");
        contentDetailsPanel.add((Widget)stepTitle);
        TreeImageResource resources = new TreeImageResource();
        this.rootNode = new Tree((Tree.Resources)resources);
        this.rootNode.addItem(new TreeItem(SafeHtmlUtils.fromString((String)"")));
        contentDetailsPanel.add((Widget)this.rootNode);
        this.previewMessageDisplayPanel.setDisplayRefreshButton(false);
        contentDetailsPanel.add((Widget)this.previewMessageDisplayPanel);
        this.menuPanel.getNextButton().setHTML("Cancel");
        contentDetailsPanel.add((Widget)this.menuPanel);
        contentDetailsDecorator.add((Widget)contentDetailsPanel);
    }

    public Tree getData() {
        return this.rootNode;
    }

    public HasClickHandlers getBackButton() {
        return this.menuPanel.getBackButton();
    }

    public HasClickHandlers getCancelButton() {
        return this.menuPanel.getNextButton();
    }

    public Widget asWidget() {
        return this;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setData(RequestResponse result) {
        this.rootNode.addItem(new TreeItem((Widget)new Label(result.getOperationFullName())));
        if (result.getErrorMessage() != null) {
            TreeItem tItem = new TreeItem((Widget)new Label(result.getErrorMessage()));
            tItem.addStyleName("soapFault");
            this.rootNode.addItem(tItem);
        }
        this.responseMessage = result.getResponseMessage();
        TreeElement rootParamNode = result.getTreeElement();
        if (rootParamNode != null) {
            for (TreeElement child : rootParamNode.getChildren()) {
                TreeItem parentItem = this.generateDisplayObject(new TreeItem(), child);
                parentItem.setState(true);
                this.rootNode.addItem(parentItem.getChild(0));
            }
        }
    }

    protected TreeItem generateDisplayObject(TreeItem parentItem, TreeElement parentTreeElement) {
        if ("simple".equals(parentTreeElement.getKind())) {
            TreeItem treeItem = new TreeItem();
            HorizontalPanel hPanel = new HorizontalPanel();
            treeItem.setWidget((Widget)hPanel);
            treeItem.setState(true);
            Label label = new Label(this.getClassType(parentTreeElement) + parentTreeElement.getName() + " = " + ((SimpleTreeElement)parentTreeElement).getValue());
            label.addStyleName("wise-result-treeItem");
            hPanel.add((Widget)label);
            parentItem.addItem(treeItem);
        } else if (parentTreeElement instanceof ComplexTreeElement) {
            TreeItem treeItem = new TreeItem();
            HorizontalPanel hPanel = new HorizontalPanel();
            treeItem.setWidget((Widget)hPanel);
            hPanel.add((Widget)new Label(this.getClassType(parentTreeElement) + parentTreeElement.getName()));
            for (TreeElement child : parentTreeElement.getChildren()) {
                this.generateDisplayObject(treeItem, child);
            }
            treeItem.setState(true);
            parentItem.addItem(treeItem);
        } else if (parentTreeElement instanceof ParameterizedTreeElement) {
            TreeItem treeItem = new TreeItem();
            HorizontalPanel hPanel = new HorizontalPanel();
            treeItem.setWidget((Widget)hPanel);
            hPanel.add((Widget)new Label(parentTreeElement.getClassType() + " : " + parentTreeElement.getName()));
            for (TreeElement child : parentTreeElement.getChildren()) {
                this.generateDisplayObject(treeItem, child);
            }
            treeItem.setState(true);
            parentItem.addItem(treeItem);
        } else if (parentTreeElement instanceof GroupTreeElement) {
            TreeItem treeItem = new TreeItem();
            HorizontalPanel gPanel = new HorizontalPanel();
            String typeName = "";
            typeName = ((GroupTreeElement)parentTreeElement).getProtoType() == null ? EndpointConfigView.getBaseType((String)((GroupTreeElement)parentTreeElement).getRawType()) : this.getClassType(((GroupTreeElement)parentTreeElement).getProtoType());
            gPanel.add((Widget)new Label(typeName + "[" + ((GroupTreeElement)parentTreeElement).getValueList().size() + "]"));
            treeItem.setWidget((Widget)gPanel);
            for (TreeElement child : ((GroupTreeElement)parentTreeElement).getValueList()) {
                this.generateDisplayObject(treeItem, child);
            }
            parentItem.addItem(treeItem);
            treeItem.setState(true);
        } else if (parentTreeElement instanceof EnumerationTreeElement) {
            TreeItem treeItem = new TreeItem();
            HorizontalPanel hPanel = new HorizontalPanel();
            treeItem.setWidget((Widget)hPanel);
            treeItem.setState(true);
            Label label = new Label(this.getClassType(parentTreeElement) + parentTreeElement.getName() + " = " + ((SimpleTreeElement)parentTreeElement).getValue());
            hPanel.add((Widget)label);
            parentItem.addItem(treeItem);
        } else {
            TreeItem treeItem = new TreeItem();
            HorizontalPanel hPanel = new HorizontalPanel();
            treeItem.addItem((Widget)hPanel);
            treeItem.setState(true);
            treeItem.setText("UNKNOWN: " + this.getClassType(parentTreeElement) + parentTreeElement.getName());
            parentItem.addItem(treeItem);
        }
        return parentItem;
    }

    private String getClassType(TreeElement parentTreeElement) {
        String classTypeStr = "";
        if (parentTreeElement != null && parentTreeElement.getClassType() != null) {
            classTypeStr = EndpointConfigView.getBaseType((String)parentTreeElement.getClassType()) + " : ";
        }
        return classTypeStr;
    }

    public DisclosurePanel getMessageDisclosurePanel() {
        return this.previewMessageDisplayPanel.getDisclosurePanel();
    }

    public void showResultMessage(String msg) {
        this.previewMessageDisplayPanel.showMessage(msg);
    }

    public void clearResultMessage() {
        this.previewMessageDisplayPanel.clearMessage();
    }
}

