/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gwt.client.view;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jboss.wise.gwt.client.handlers.URLFieldValidator;
import org.jboss.wise.gwt.client.presenter.WsdlPresenter;

public class WsdlView
extends Composite
implements WsdlPresenter.Display {
    private FlexTable contactsTable;
    private FlexTable contentTable;
    private TextBox wsdlAddress;
    private Label errorLabel;
    private URLFieldValidator urlFieldValidor;
    private Button sendButton;

    public WsdlView() {
        SimplePanel contentTableDecorator = new SimplePanel();
        this.initWidget((Widget)contentTableDecorator);
        contentTableDecorator.setWidth("100%");
        VerticalPanel contentDetailsPanel = new VerticalPanel();
        contentDetailsPanel.setWidth("100%");
        contentDetailsPanel.add((Widget)this.createInputDetails());
        contentDetailsPanel.add((Widget)this.createMenuPanel());
        contentDetailsPanel.add((Widget)this.createWsdlList());
        contentTableDecorator.add((Widget)contentDetailsPanel);
    }

    public HasClickHandlers getSendButton() {
        return this.sendButton;
    }

    private HorizontalPanel createInputDetails() {
        HorizontalPanel contentDetailsPanel = new HorizontalPanel();
        contentDetailsPanel.add((Widget)new Label("URL: "));
        this.wsdlAddress = new TextBox();
        this.wsdlAddress.setVisibleLength(56);
        this.wsdlAddress.addStyleName("wsdl.input.box");
        contentDetailsPanel.add((Widget)this.wsdlAddress);
        this.errorLabel = new Label("Invalid URL");
        contentDetailsPanel.add((Widget)this.errorLabel);
        this.errorLabel.setVisible(false);
        this.errorLabel.addStyleName("urlValidationError");
        this.wsdlAddress.setFocus(true);
        this.urlFieldValidor = new URLFieldValidator(this.wsdlAddress, this.errorLabel);
        this.wsdlAddress.addKeyPressHandler((KeyPressHandler)this.urlFieldValidor);
        return contentDetailsPanel;
    }

    private HorizontalPanel createMenuPanel() {
        HorizontalPanel menuPanel = new HorizontalPanel();
        this.sendButton = new Button("Read WSDL");
        this.sendButton.addStyleName("readWsdlButton");
        menuPanel.add((Widget)this.sendButton);
        return menuPanel;
    }

    private FlexTable createWsdlList() {
        this.contentTable = new FlexTable();
        this.contentTable.addStyleName("wise-deployed-wsdl-table");
        String rowStyleWidth = "40em";
        this.contentTable.setWidth(rowStyleWidth);
        this.contentTable.getCellFormatter().setWidth(0, 0, rowStyleWidth);
        this.contentTable.getFlexCellFormatter().setVerticalAlignment(0, 0, DockPanel.ALIGN_TOP);
        this.contactsTable = new FlexTable();
        this.contactsTable.setCellSpacing(0);
        this.contactsTable.setCellPadding(0);
        this.contactsTable.setWidth("100%");
        Label title = new Label("Deployed WSDLs");
        this.contentTable.setWidget(0, 0, (Widget)title);
        this.contentTable.setWidget(1, 0, (Widget)this.contactsTable);
        return this.contentTable;
    }

    public HasClickHandlers getList() {
        return this.contactsTable;
    }

    public void setData(List<String> data) {
        this.contactsTable.removeAllRows();
        for (int i = 0; i < data.size(); ++i) {
            this.contactsTable.setText(i, 1, data.get(i));
        }
        HTMLTable.RowFormatter rf = this.contactsTable.getRowFormatter();
        for (int row = 0; row < this.contactsTable.getRowCount(); ++row) {
            rf.addStyleName(row, "wise-wsdl-list-FlexTable");
        }
    }

    public void setData(String data) {
        if (data != null && data.length() > 0) {
            this.wsdlAddress.setValue((Object)data);
        }
    }

    public int getClickedRow(ClickEvent event) {
        HTMLTable.RowFormatter rf = this.contactsTable.getRowFormatter();
        for (int row = 0; row < this.contactsTable.getRowCount(); ++row) {
            rf.removeStyleName(row, "wise-wsdl-list-selected");
        }
        int selectedRow = -1;
        HTMLTable.Cell cell = this.contactsTable.getCellForEvent(event);
        if (cell != null && cell.getCellIndex() > 0) {
            selectedRow = cell.getRowIndex();
            rf.addStyleName(selectedRow, "wise-wsdl-list-selected");
        }
        return selectedRow;
    }

    public Widget asWidget() {
        return this;
    }

    public HasValue<String> getWsdlAddress() {
        return this.wsdlAddress;
    }

    public void setWsdlAddress(String wsdlAddress) {
        this.wsdlAddress.setValue((Object)wsdlAddress);
    }

    public boolean urlFieldValidation() {
        return this.urlFieldValidor.urlFieldValidation();
    }
}

