/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.gwt.server;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.wise.core.exception.WiseAuthenticationException;
import org.jboss.wise.core.exception.WiseProcessingException;
import org.jboss.wise.core.exception.WiseURLException;
import org.jboss.wise.core.exception.WiseWebServiceException;
import org.jboss.wise.gwt.client.MainService;
import org.jboss.wise.gwt.shared.Service;
import org.jboss.wise.gwt.shared.WsdlAddress;
import org.jboss.wise.gwt.shared.WsdlInfo;
import org.jboss.wise.gwt.shared.tree.element.RequestResponse;
import org.jboss.wise.gwt.shared.tree.element.TreeElement;
import org.jboss.wise.shared.GWTClientConversationBean;

public class MainServiceImpl
extends RemoteServiceServlet
implements MainService {
    private final HashMap<String, WsdlAddress> address = new HashMap();
    private ArrayList<WsdlAddress> wsdlAddress = new ArrayList();
    private GWTClientConversationBean gwtClientConversationBean = new GWTClientConversationBean();

    public MainServiceImpl() {
        this.initAddress();
    }

    private void initAddress() {
        List wsdlList = this.gwtClientConversationBean.getWsdlList();
        for (int i = 0; i < wsdlList.size(); ++i) {
            WsdlAddress detail = new WsdlAddress(String.valueOf(i), (String)wsdlList.get(i));
            this.wsdlAddress.add(detail);
            this.address.put(detail.getId(), detail);
        }
    }

    public ArrayList<WsdlAddress> getAddressDetails() {
        return this.wsdlAddress;
    }

    public WsdlAddress getAddress(String id) {
        return (WsdlAddress)this.address.get(id);
    }

    public ArrayList<Service> getEndpoints(WsdlInfo wsdlInfo) throws WiseProcessingException {
        ArrayList<Service> endpointList = new ArrayList<Service>();
        if (wsdlInfo != null) {
            this.gwtClientConversationBean.setWsdlUser(wsdlInfo.getUser());
            this.gwtClientConversationBean.setWsdlPwd(wsdlInfo.getPassword());
            this.gwtClientConversationBean.setWsdlUrl(wsdlInfo.getWsdl());
            this.gwtClientConversationBean.readWsdl();
            List serviceList = this.gwtClientConversationBean.getServices();
            endpointList.addAll(serviceList);
        } else {
            Window.alert((String)"URL information not specified");
        }
        return endpointList;
    }

    public RequestResponse getEndpointReflection(String id) {
        if (id != null) {
            this.gwtClientConversationBean.setCurrentOperation(id);
            return this.gwtClientConversationBean.parseOperationParameters(id);
        }
        return null;
    }

    public String getRequestPreview(TreeElement rootTreeElement) {
        return this.gwtClientConversationBean.generateRequestPreview(rootTreeElement);
    }

    public RequestResponse getPerformInvocationOutputTree(TreeElement rootTreeElement, WsdlInfo wsdlInfo) throws WiseWebServiceException, WiseProcessingException, WiseAuthenticationException {
        this.gwtClientConversationBean.setInvocationUrl(wsdlInfo.getWsdl());
        this.gwtClientConversationBean.setInvocationUser(wsdlInfo.getUser());
        this.gwtClientConversationBean.setInvocationPwd(wsdlInfo.getPassword());
        return this.gwtClientConversationBean.performInvocation(rootTreeElement);
    }

    public boolean isValidURL(String url) throws WiseURLException {
        return this.gwtClientConversationBean.isValidURL(url);
    }
}

