/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.shared;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wise.core.client.BasicWSDynamicClient;
import org.jboss.wise.core.client.WSMethod;
import org.jboss.wise.core.client.builder.BasicWSDynamicClientBuilder;
import org.jboss.wise.core.client.impl.reflection.builder.ReflectionBasedBasicWSDynamicClientBuilder;
import org.jboss.wise.core.exception.WiseAuthenticationException;
import org.jboss.wise.core.exception.WiseProcessingException;
import org.jboss.wise.core.exception.WiseURLException;
import org.jboss.wise.core.exception.WiseWebServiceException;
import org.jboss.wise.gui.ClientConversationBean;
import org.jboss.wise.gui.ClientHelper;
import org.jboss.wise.gui.model.TreeNode;
import org.jboss.wise.gui.model.TreeNodeImpl;
import org.jboss.wise.gui.treeElement.ComplexWiseTreeElement;
import org.jboss.wise.gui.treeElement.EnumerationWiseTreeElement;
import org.jboss.wise.gui.treeElement.GroupWiseTreeElement;
import org.jboss.wise.gui.treeElement.LazyLoadWiseTreeElement;
import org.jboss.wise.gui.treeElement.ParameterizedWiseTreeElement;
import org.jboss.wise.gui.treeElement.SimpleWiseTreeElement;
import org.jboss.wise.gui.treeElement.WiseTreeElement;
import org.jboss.wise.gwt.shared.tree.element.ComplexTreeElement;
import org.jboss.wise.gwt.shared.tree.element.EnumerationTreeElement;
import org.jboss.wise.gwt.shared.tree.element.GroupTreeElement;
import org.jboss.wise.gwt.shared.tree.element.ParameterizedTreeElement;
import org.jboss.wise.gwt.shared.tree.element.RequestResponse;
import org.jboss.wise.gwt.shared.tree.element.SimpleTreeElement;
import org.jboss.wise.gwt.shared.tree.element.TreeElement;
import org.jboss.wise.gwt.shared.tree.element.TreeElementFactory;
import org.jboss.wise.shared.WsdlFinder;
import org.jboss.wise.soap.fault.CodeType;
import org.jboss.wise.soap.fault.DetailType;
import org.jboss.wise.soap.fault.SOAP11Fault;
import org.jboss.wise.soap.fault.SOAP12Fault;
import org.jboss.wise.soap.fault.SubcodeType;
import org.w3c.dom.Element;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class GWTClientConversationBean
extends ClientConversationBean {
    private static final long serialVersionUID = 4531727535065189366L;
    private static Logger log = Logger.getLogger(GWTClientConversationBean.class);
    private Map<String, WiseTreeElement> treeElementMap = new HashMap();
    private HashMap<String, WiseTreeElement> lazyLoadMap = new HashMap();
    private WsdlFinder wsdlFinder = null;

    public void readWsdl() throws WiseProcessingException {
        this.cleanup();
        try {
            BasicWSDynamicClientBuilder builder = new ReflectionBasedBasicWSDynamicClientBuilder().verbose(true).messageStream(ps).keepSource(true).excludeNonSOAPPorts(true).maxThreadPoolSize(1);
            String wsdlUser = this.getWsdlUser();
            String wsdlPwd = this.getWsdlPwd();
            builder.userName(wsdlUser);
            this.setInvocationUser(wsdlUser);
            builder.password(wsdlPwd);
            this.setInvocationPwd(wsdlPwd);
            this.client = builder.wsdlURL(this.getWsdlUrl()).build();
        }
        catch (Exception e) {
            this.setError("Could not read WSDL from specified URL. Please check credentials and see logs for further information.");
            GWTClientConversationBean.logException((Exception)e);
            throw new WiseProcessingException("Could not read WSDL from specified URL.", e.getCause());
        }
        if (this.client != null) {
            try {
                List services = ClientHelper.convertServicesToGui((Map)this.client.processServices());
                String currentOperation = ClientHelper.getFirstGuiOperation((List)services);
                this.setServices(services);
                this.setCurrentOperation(currentOperation);
            }
            catch (Exception e) {
                this.setError("Could not parse WSDL from specified URL. Please check logs for further information.");
                GWTClientConversationBean.logException((Exception)e);
                throw new WiseProcessingException("Could not read WSDL from specified URL.", e.getCause());
            }
        }
    }

    public RequestResponse parseOperationParameters(String curOperation) {
        try {
            List services = this.getServices();
            String currentOperation = this.getCurrentOperation();
            String currentOperationFullName = ClientHelper.getOperationFullName((String)currentOperation, (List)services);
            TreeNodeImpl inputTree = ClientHelper.convertOperationParametersToGui((WSMethod)ClientHelper.getWSMethod((String)curOperation, (BasicWSDynamicClient)this.client), (BasicWSDynamicClient)this.client);
            this.setInputTree(inputTree);
            this.setCurrentOperationFullName(currentOperationFullName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TreeElement treeElement = this.wiseDataPostProcess(this.getInputTree());
        RequestResponse invResult = new RequestResponse();
        invResult.setOperationFullName(this.getCurrentOperationFullName());
        invResult.setTreeElement(treeElement);
        return invResult;
    }

    public String generateRequestPreview(TreeElement rootTreeElement) {
        this.userDataPostProcess(rootTreeElement);
        this.generateRequestPreview();
        return this.getRequestPreview();
    }

    public RequestResponse performInvocation(TreeElement root) throws WiseWebServiceException, WiseProcessingException, WiseAuthenticationException {
        this.userDataPostProcess(root);
        RequestResponse invResult = new RequestResponse();
        invResult.setOperationFullName(this.getCurrentOperationFullName());
        this.performInvocation();
        TreeElement treeE = null;
        TreeNodeImpl outputTree = this.getOutputTree();
        if (outputTree != null) {
            treeE = this.wiseOutputPostProcess(outputTree);
        }
        invResult.setResponseMessage(this.getResponseMessage());
        invResult.setTreeElement(treeE);
        invResult.setErrorMessage(this.getError());
        if (this.getError() != null) {
            TreeElement faultE = this.getSoapFault(this.getResponseMessage());
            invResult.setTreeElement(faultE);
        }
        return invResult;
    }

    private TreeElement getSoapFault(String responseMessage) {
        if (responseMessage != null) {
            if (responseMessage.contains("http://schemas.xmlsoap.org/soap/envelope")) {
                return this.unmarshalSOAP11Fault(this.getResponseMessage());
            }
            if (responseMessage.contains("http://www.w3.org/2003/05/soap-envelope")) {
                return this.unmarshalSOAP12Fault(this.getResponseMessage());
            }
        }
        return null;
    }

    private TreeElement unmarshalSOAP12Fault(String responseMessage) {
        SimpleTreeElement rootTreeElement = new SimpleTreeElement();
        try {
            TreeElement detailTreeElement;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SOAP12Fault.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(responseMessage);
            SOAP12Fault soap12Fault = (SOAP12Fault)unmarshaller.unmarshal((Reader)reader);
            ComplexTreeElement errorRoot = new ComplexTreeElement();
            errorRoot.setName("SOAP 1.2 Fault");
            rootTreeElement.addChild((TreeElement)errorRoot);
            if (soap12Fault.getCode() != null) {
                ComplexTreeElement subcodeTreeElement;
                ComplexTreeElement codeTreeElement = new ComplexTreeElement();
                codeTreeElement.setName("Code");
                errorRoot.addChild((TreeElement)codeTreeElement);
                CodeType codeType = soap12Fault.getCode();
                if (codeType.getValue() != null) {
                    SimpleTreeElement value = new SimpleTreeElement();
                    value.setName("value");
                    value.setValue(this.processQName(codeType.getValue()));
                    codeTreeElement.addChild((TreeElement)value);
                }
                if ((subcodeTreeElement = this.processSubCode(codeType.getSubcode())) != null) {
                    errorRoot.addChild((TreeElement)subcodeTreeElement);
                }
            }
            if (soap12Fault.getReason() != null) {
                ComplexTreeElement reason = new ComplexTreeElement();
                reason.setName("Reason");
                for (String s : soap12Fault.getReason().getTextList()) {
                    SimpleTreeElement text = new SimpleTreeElement();
                    text.setName("Text");
                    text.setValue(s);
                    reason.addChild((TreeElement)text);
                }
                errorRoot.addChild((TreeElement)reason);
            }
            if (soap12Fault.getRole() != null) {
                SimpleTreeElement role = new SimpleTreeElement();
                role.setName("Role");
                role.setValue(soap12Fault.getRole());
                errorRoot.addChild((TreeElement)role);
            }
            if ((detailTreeElement = this.processDetailType(soap12Fault.getDetail())) != null) {
                errorRoot.addChild(detailTreeElement);
            }
        }
        catch (JAXBException e) {
            log.error((Object)e);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return rootTreeElement;
    }

    private TreeElement unmarshalSOAP11Fault(String responseMessage) {
        SimpleTreeElement rootTreeElement = new SimpleTreeElement();
        try {
            TreeElement detailTreeElement;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SOAP11Fault.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(responseMessage);
            SOAP11Fault soap11Fault = (SOAP11Fault)unmarshaller.unmarshal((Reader)reader);
            ComplexTreeElement errorRoot = new ComplexTreeElement();
            errorRoot.setName("SOAP 1.1 Fault");
            rootTreeElement.addChild((TreeElement)errorRoot);
            if (soap11Fault.getFaultcode() != null) {
                SimpleTreeElement codeTreeElement = new SimpleTreeElement();
                codeTreeElement.setName("faultcode");
                codeTreeElement.setValue(this.processQName(soap11Fault.getFaultcode()));
                errorRoot.addChild((TreeElement)codeTreeElement);
            }
            if (soap11Fault.getFaultString() != null) {
                SimpleTreeElement faultstringTreeElement = new SimpleTreeElement();
                faultstringTreeElement.setName("faultstring");
                faultstringTreeElement.setValue(soap11Fault.getFaultString());
                errorRoot.addChild((TreeElement)faultstringTreeElement);
            }
            if (soap11Fault.getFaultactor() != null) {
                SimpleTreeElement faultactorTreeElement = new SimpleTreeElement();
                faultactorTreeElement.setName("faultactor");
                faultactorTreeElement.setValue(soap11Fault.getFaultactor());
                errorRoot.addChild((TreeElement)faultactorTreeElement);
            }
            if ((detailTreeElement = this.processDetailType(soap11Fault.getDetail())) != null) {
                errorRoot.addChild(detailTreeElement);
            }
        }
        catch (JAXBException e) {
            log.error((Object)e);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return rootTreeElement;
    }

    private ComplexTreeElement processSubCode(SubcodeType subcodeType) {
        ComplexTreeElement subcodeTreeElement;
        if (subcodeType == null) {
            return null;
        }
        ComplexTreeElement parentTreeElement = new ComplexTreeElement();
        parentTreeElement.setName("Subcode");
        if (subcodeType.getValue() != null) {
            SimpleTreeElement simpleTreeElement = new SimpleTreeElement();
            simpleTreeElement.setValue(this.processQName(subcodeType.getValue()));
            simpleTreeElement.setName("Value");
            parentTreeElement.addChild((TreeElement)simpleTreeElement);
        }
        if ((subcodeTreeElement = this.processSubCode(subcodeType.getSubcode())) != null) {
            parentTreeElement.addChild((TreeElement)subcodeTreeElement);
        }
        return parentTreeElement;
    }

    private TreeElement processDetailType(DetailType detailType) {
        if (detailType != null) {
            ComplexTreeElement detailTreeElement = new ComplexTreeElement();
            detailTreeElement.setName("Detail");
            for (Element element : detailType.getDetails()) {
                SimpleTreeElement detail = new SimpleTreeElement();
                detail.setName(element.getTagName());
                detail.setValue(element.getTextContent());
                detailTreeElement.addChild((TreeElement)detail);
            }
            return detailTreeElement;
        }
        return null;
    }

    private String processQName(QName qname) {
        String prefix = qname.getPrefix() == null ? "" : qname.getPrefix();
        String localPart = qname.getLocalPart() == null ? "" : qname.getLocalPart();
        String colon = "";
        if (!prefix.isEmpty() && !localPart.isEmpty()) {
            colon = ":";
        }
        return prefix + colon + localPart;
    }

    private TreeElement wiseDataPostProcess(TreeNodeImpl tNode) {
        this.lazyLoadMap.clear();
        SimpleTreeElement treeElement = new SimpleTreeElement();
        List children = treeElement.getChildren();
        Iterator keyIt = tNode.getChildrenKeysIterator();
        while (keyIt.hasNext()) {
            WiseTreeElement child = (WiseTreeElement)tNode.getChild(keyIt.next());
            TreeElement te = this.wiseDataTransfer(child);
            children.add(te);
        }
        return treeElement;
    }

    private TreeElement wiseDataTransfer(WiseTreeElement wte) {
        TreeElement treeElement = TreeElementFactory.create((String)wte.getKind());
        if (treeElement instanceof GroupTreeElement) {
            GroupTreeElement gTreeElement = (GroupTreeElement)treeElement;
            WiseTreeElement protoType = ((GroupWiseTreeElement)wte).getPrototype();
            TreeElement tElement = this.wiseDataTransfer(protoType);
            gTreeElement.setProtoType(tElement);
            String rType = gTreeElement.getCleanClassName(((ParameterizedType)wte.getClassType()).getRawType().toString());
            gTreeElement.setClassType(rType);
        } else if (wte instanceof ComplexWiseTreeElement) {
            ComplexWiseTreeElement cNode = (ComplexWiseTreeElement)wte;
            Iterator keyIt = cNode.getChildrenKeysIterator();
            while (keyIt.hasNext()) {
                WiseTreeElement child = (WiseTreeElement)cNode.getChild(keyIt.next());
                TreeElement te = this.wiseDataTransfer(child);
                te.setId(child.getId().toString());
                treeElement.addChild(te);
            }
            this.lazyLoadMap.put(cNode.getClassType().toString(), cNode);
        } else if (wte instanceof ParameterizedWiseTreeElement) {
            ParameterizedWiseTreeElement cNode = (ParameterizedWiseTreeElement)wte;
            Iterator keyIt = cNode.getChildrenKeysIterator();
            while (keyIt.hasNext()) {
                WiseTreeElement child = (WiseTreeElement)cNode.getChild(keyIt.next());
                TreeElement te = this.wiseDataTransfer(child);
                te.setId(child.getId().toString());
                treeElement.addChild(te);
            }
        } else if (treeElement instanceof EnumerationTreeElement) {
            EnumerationTreeElement eTreeElement = (EnumerationTreeElement)treeElement;
            Map eValuesMap = ((EnumerationWiseTreeElement)wte).getValidValue();
            if (eValuesMap != null) {
                eTreeElement.getEnumValues().addAll(eValuesMap.keySet());
            }
            eTreeElement.setValue(((SimpleWiseTreeElement)wte).getValue());
        } else if (wte instanceof SimpleWiseTreeElement) {
            ((SimpleTreeElement)treeElement).setValue(((SimpleWiseTreeElement)wte).getValue());
        }
        if (!(treeElement instanceof GroupTreeElement) && wte.getClassType() != null) {
            treeElement.setClassType(treeElement.getCleanClassName(wte.getClassType().toString()));
        }
        treeElement.setName(wte.getName());
        treeElement.setKind(wte.getKind());
        treeElement.setId(Integer.toString(wte.hashCode()));
        treeElement.setNil(wte.isNil());
        treeElement.setNillable(wte.isNillable());
        this.treeElementMap.put(treeElement.getId(), wte);
        return treeElement;
    }

    private TreeElement wiseOutputPostProcess(TreeNodeImpl tNode) {
        SimpleTreeElement treeElement = new SimpleTreeElement();
        if (tNode == null) {
            log.error((Object)"wiseOutputPostProcess tNode is NULL");
        } else {
            List children = treeElement.getChildren();
            Iterator keyIt = tNode.getChildrenKeysIterator();
            while (keyIt.hasNext()) {
                WiseTreeElement child = (WiseTreeElement)tNode.getChild(keyIt.next());
                TreeElement te = this.wiseOutputTransfer(child);
                children.add(te);
            }
        }
        return treeElement;
    }

    private TreeElement wiseOutputTransfer(WiseTreeElement wte) {
        TreeElement treeElement = TreeElementFactory.create((String)wte.getKind());
        if (treeElement instanceof GroupTreeElement) {
            Type[] typeArr;
            GroupTreeElement gTreeElement = (GroupTreeElement)treeElement;
            WiseTreeElement protoType = ((GroupWiseTreeElement)wte).getPrototype();
            if (protoType != null) {
                TreeElement pElement = this.wiseOutputTransfer(protoType);
                gTreeElement.setProtoType(pElement);
            }
            if ((typeArr = ((ParameterizedType)wte.getClassType()).getActualTypeArguments()) != null && typeArr.length > 0) {
                String actualType = typeArr[0].toString();
                gTreeElement.setRawType(actualType);
            } else {
                log.error((Object)("ERROR parameterizedType actualTypeArguments not found for " + wte.getName()));
            }
            String rType = gTreeElement.getCleanClassName(((ParameterizedType)wte.getClassType()).getRawType().toString());
            gTreeElement.setClassType(rType);
            GroupWiseTreeElement gChild = (GroupWiseTreeElement)wte;
            Iterator childKeyIt = gChild.getChildrenKeysIterator();
            while (childKeyIt.hasNext()) {
                WiseTreeElement c = (WiseTreeElement)gChild.getChild(childKeyIt.next());
                TreeElement te = this.wiseOutputTransfer(c);
                gTreeElement.addValue(te);
            }
        } else if (wte instanceof ComplexWiseTreeElement) {
            ComplexWiseTreeElement cNode = (ComplexWiseTreeElement)wte;
            Iterator keyIt = cNode.getChildrenKeysIterator();
            while (keyIt.hasNext()) {
                WiseTreeElement child = (WiseTreeElement)cNode.getChild(keyIt.next());
                TreeElement te = this.wiseOutputTransfer(child);
                treeElement.addChild(te);
            }
            treeElement.setClassType(cNode.getClassType().toString());
        } else if (wte instanceof ParameterizedWiseTreeElement) {
            ParameterizedWiseTreeElement cNode = (ParameterizedWiseTreeElement)wte;
            Iterator keyIt = cNode.getChildrenKeysIterator();
            while (keyIt.hasNext()) {
                WiseTreeElement child = (WiseTreeElement)cNode.getChild(keyIt.next());
                TreeElement te = this.wiseOutputTransfer(child);
                treeElement.addChild(te);
            }
            treeElement.setClassType(((ParameterizedTypeImpl)cNode.getClassType()).toString());
        } else if (treeElement instanceof EnumerationTreeElement) {
            EnumerationTreeElement eTreeElement = (EnumerationTreeElement)treeElement;
            Map eValuesMap = ((EnumerationWiseTreeElement)wte).getValidValue();
            if (eValuesMap != null) {
                eTreeElement.getEnumValues().addAll(eValuesMap.keySet());
            }
            eTreeElement.setValue(((SimpleWiseTreeElement)wte).getValue());
            if (wte.getClassType() != null) {
                eTreeElement.setClassType(treeElement.getCleanClassName(wte.getClassType().toString()));
            }
        } else {
            if (wte instanceof SimpleWiseTreeElement) {
                if (wte.isNil()) {
                    ((SimpleTreeElement)treeElement).setValue("***NIL***");
                } else {
                    ((SimpleTreeElement)treeElement).setValue(((SimpleWiseTreeElement)wte).getValue());
                }
            }
            if (wte.getClassType() != null) {
                treeElement.setClassType(treeElement.getCleanClassName(wte.getClassType().toString()));
            }
        }
        treeElement.setName(wte.getName());
        treeElement.setKind(wte.getKind());
        treeElement.setId(Integer.toString(wte.hashCode()));
        this.treeElementMap.put(treeElement.getId(), wte);
        return treeElement;
    }

    private void userDataPostProcess(TreeElement root) {
        if (root != null) {
            for (TreeElement te : root.getChildren()) {
                WiseTreeElement wte = (WiseTreeElement)this.treeElementMap.get(te.getId());
                if (wte == null) {
                    log.error((Object)"ERROR: not WiseTreeElement for TreeElement");
                    continue;
                }
                this.userDataTransfer(te, wte);
            }
        }
    }

    public void userDataTransfer(TreeElement treeElement, WiseTreeElement wte) {
        if ("simple".equals(treeElement.getKind())) {
            if (wte instanceof SimpleWiseTreeElement) {
                if (!treeElement.isNil()) {
                    ((SimpleWiseTreeElement)wte).setValue(((SimpleTreeElement)treeElement).getValue() == null ? "" : ((SimpleTreeElement)treeElement).getValue());
                }
                wte.setNil(treeElement.isNil());
            } else {
                log.error((Object)("ERROR: incompatible types. TreeElement: " + treeElement.getKind() + "  WiseTreeElement: " + wte.getClass().getName()));
            }
        } else if (treeElement instanceof ComplexTreeElement) {
            if (wte instanceof ComplexWiseTreeElement) {
                ComplexTreeElement cte = (ComplexTreeElement)treeElement;
                ComplexWiseTreeElement cWise = (ComplexWiseTreeElement)wte;
                if (!treeElement.isNil()) {
                    Iterator childKeyIt = cWise.getChildrenKeysIterator();
                    HashMap<String, TreeNode> wiseChildren = new HashMap<String, TreeNode>();
                    while (childKeyIt.hasNext()) {
                        TreeNode tNode = cWise.getChild(childKeyIt.next());
                        wiseChildren.put(((WiseTreeElement)tNode).getName(), tNode);
                    }
                    int cnt = cte.getChildren().size();
                    if (cnt == wiseChildren.size()) {
                        for (int i = 0; i < cnt; ++i) {
                            TreeNode tNode = (TreeNode)wiseChildren.get(((TreeElement)cte.getChildren().get(i)).getName());
                            if (tNode != null) {
                                this.userDataTransfer((TreeElement)cte.getChildren().get(i), (WiseTreeElement)tNode);
                                continue;
                            }
                            log.error((Object)("ERROR: No Wise treeNode found for name: " + ((TreeElement)cte.getChildren().get(i)).getName()));
                        }
                    } else {
                        log.error((Object)("ERROR: incompatable child count: ComplexTreeElement cnt: " + cte.getChildren().size() + "  ComplexWiseTreeElement cnt: " + wiseChildren.size()));
                    }
                }
                cWise.setNil(treeElement.isNil());
            } else {
                log.error((Object)("ERROR: incompatible types. TreeElement: " + treeElement.getKind() + "  WiseTreeElement: " + wte.getClass().getName()));
            }
        } else if (treeElement instanceof ParameterizedTreeElement) {
            if (wte instanceof ParameterizedWiseTreeElement) {
                ParameterizedTreeElement cte = (ParameterizedTreeElement)treeElement;
                ParameterizedWiseTreeElement cWise = (ParameterizedWiseTreeElement)wte;
                if (!treeElement.isNil()) {
                    Iterator childKeyIt = cWise.getChildrenKeysIterator();
                    HashMap<String, TreeNode> wiseChildren = new HashMap<String, TreeNode>();
                    while (childKeyIt.hasNext()) {
                        TreeNode tNode = cWise.getChild(childKeyIt.next());
                        wiseChildren.put(((WiseTreeElement)tNode).getName(), tNode);
                    }
                    int cnt = cte.getChildren().size();
                    if (cnt == wiseChildren.size()) {
                        for (int i = 0; i < cnt; ++i) {
                            TreeNode tNode = (TreeNode)wiseChildren.get(((TreeElement)cte.getChildren().get(i)).getName());
                            if (tNode != null) {
                                this.userDataTransfer((TreeElement)cte.getChildren().get(i), (WiseTreeElement)tNode);
                                continue;
                            }
                            log.error((Object)("ERROR: No Wise treeNode found for name: " + ((TreeElement)cte.getChildren().get(i)).getName()));
                        }
                    } else {
                        log.error((Object)("ERROR: incompatable child count: ParameterizedTreeElement cnt: " + cte.getChildren().size() + "  ParameterizedWiseTreeElement cnt: " + wiseChildren.size()));
                    }
                }
                cWise.setNil(treeElement.isNil());
            } else {
                log.error((Object)("ERROR: incompatible types. TreeElement: " + treeElement.getKind() + "  WiseTreeElement: " + wte.getClass().getName()));
            }
        } else if (treeElement instanceof GroupTreeElement) {
            if (wte instanceof GroupWiseTreeElement) {
                GroupTreeElement cte = (GroupTreeElement)treeElement;
                GroupWiseTreeElement cWise = (GroupWiseTreeElement)wte;
                if (!treeElement.isNil()) {
                    Iterator keyIt = cWise.getChildrenKeysIterator();
                    ArrayList keyList = new ArrayList();
                    while (keyIt.hasNext()) {
                        keyList.add(keyIt.next());
                    }
                    for (Object key : keyList) {
                        cWise.removeChild(key);
                    }
                    if (cWise.getPrototype() instanceof LazyLoadWiseTreeElement) {
                        WiseTreeElement protoChildWte = (WiseTreeElement)this.lazyLoadMap.get(cWise.getPrototype().getClassType().toString());
                        WiseTreeElement clone = protoChildWte.clone();
                        cWise.setPrototype(clone);
                    }
                    for (TreeElement child : cte.getValueList()) {
                        WiseTreeElement protoChildWte = cWise.incrementChildren();
                        this.userDataTransfer(child, protoChildWte);
                    }
                }
                cWise.setNil(treeElement.isNil());
            } else {
                log.error((Object)("ERROR: incompatible types. TreeElement: " + treeElement.getKind() + "  WiseTreeElement: " + wte.getClass().getName()));
            }
        } else if (treeElement instanceof EnumerationTreeElement) {
            if (wte instanceof EnumerationWiseTreeElement) {
                if (treeElement.isNil()) {
                    ((EnumerationWiseTreeElement)wte).setValue(((EnumerationTreeElement)treeElement).getValue());
                    wte.setNil(treeElement.isNil());
                }
                wte.setNil(treeElement.isNil());
                ((EnumerationWiseTreeElement)wte).setValue(((EnumerationTreeElement)treeElement).getValue());
            } else {
                log.error((Object)("ERROR: incompatible types. TreeElement: " + treeElement.getKind() + "  WiseTreeElement: " + wte.getClass().getName()));
            }
        }
    }

    public List<String> getWsdlList() {
        if (this.wsdlFinder == null) {
            this.wsdlFinder = new WsdlFinder();
        }
        return this.wsdlFinder.getWsdlList();
    }

    protected void cleanup() {
        super.cleanup();
        this.treeElementMap.clear();
    }

    public TreeElement testItWiseOutputPostProcess(TreeNodeImpl tNode) {
        return this.wiseOutputPostProcess(tNode);
    }

    public TreeElement testItWiseDataPostProcess(TreeNodeImpl tNode) {
        return this.wiseDataPostProcess(tNode);
    }

    public void testItUserDataTransfer(TreeElement treeElement, WiseTreeElement wte) {
        this.userDataTransfer(treeElement, wte);
    }

    public boolean isValidURL(String url) throws WiseURLException {
        URL u = null;
        try {
            u = new URL(url);
            u.toURI();
        }
        catch (MalformedURLException em) {
            throw new WiseURLException(em.getMessage(), (Throwable)em);
        }
        catch (URISyntaxException eu) {
            throw new WiseURLException(eu.getMessage(), (Throwable)eu);
        }
        return true;
    }
}

