/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.shared;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class WsdlFinder
implements Serializable {
    private static final long serialVersionUID = -6841057226758482815L;
    private List<String> wsdlList = new ArrayList();

    public WsdlFinder() {
        try {
            List dataSources = this.getDeployedApps();
            for (ModelNode dataSource : dataSources) {
                List endpointList = this.getEndpoints(dataSource.asString());
                for (ModelNode endPt : endpointList) {
                    String wsdlName = this.getWsdlUrl(endPt);
                    if (wsdlName == null) continue;
                    this.wsdlList.add(wsdlName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getWsdlList() {
        return this.wsdlList;
    }

    private String getWsdlUrl(ModelNode mNode) {
        for (Property p : mNode.asPropertyList()) {
            for (Property pp : p.getValue().asPropertyList()) {
                if (!pp.getValue().has("wsdl-url")) continue;
                return pp.getValue().get("wsdl-url").asString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ModelNode> getEndpoints(String appName) throws IOException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource");
        ModelNode address = request.get("address");
        address.add("deployment", appName);
        address.add("subsystem", "webservices");
        request.get("recursive").set(true);
        ModelControllerClient client = null;
        ArrayList<ModelNode> resultList = new ArrayList<ModelNode>();
        try {
            client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("127.0.0.1"), (int)9990);
            ModelNode response = client.execute(new OperationBuilder(request).build());
            if ("success".equals(response.get("outcome").asString())) {
                resultList.addAll(response.get("result").asList());
            }
        }
        finally {
            this.safeClose((Closeable)client);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ModelNode> getDeployedApps() throws IOException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-children-names");
        request.get("child-type").set("deployment");
        ModelControllerClient client = null;
        ArrayList<ModelNode> resultList = new ArrayList<ModelNode>();
        try {
            client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("127.0.0.1"), (int)9990);
            ModelNode response = client.execute(new OperationBuilder(request).build());
            if ("success".equals(response.get("outcome").asString())) {
                resultList.addAll(response.get("result").asList());
            }
        }
        finally {
            this.safeClose((Closeable)client);
        }
        return resultList;
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

