/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.soap.fault;

import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import org.jboss.wise.soap.fault.DOMUtil;
import org.jboss.wise.soap.fault.DetailType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"faultcode", "faultstring", "faultactor", "detail"})
@XmlRootElement(name="Fault", namespace="http://schemas.xmlsoap.org/soap/envelope/")
public class SOAP11Fault {
    @XmlElement(namespace="")
    private QName faultcode;
    @XmlElement(namespace="")
    private String faultstring;
    @XmlElement(namespace="")
    private String faultactor;
    @XmlElement(namespace="")
    private DetailType detail;

    public SOAP11Fault() {
    }

    public SOAP11Fault(QName code, String reason, String actor, Element detailObject) {
        this.faultcode = code;
        this.faultstring = reason;
        this.faultactor = actor;
        if (detailObject != null) {
            if (detailObject.getNamespaceURI().equals("") && detailObject.getLocalName().equals("detail")) {
                this.detail = new DetailType();
                for (Element detailEntry : DOMUtil.getChildElements((Node)detailObject)) {
                    this.detail.getDetails().add(detailEntry);
                }
            } else {
                this.detail = new DetailType(detailObject);
            }
        }
    }

    public SOAP11Fault(SOAPFault fault) {
        this.faultcode = fault.getFaultCodeAsQName();
        this.faultstring = fault.getFaultString();
        this.faultactor = fault.getFaultActor();
        if (fault.getDetail() != null) {
            this.detail = new DetailType();
            Iterator iter = fault.getDetail().getDetailEntries();
            while (iter.hasNext()) {
                Element fd = (Element)iter.next();
                this.detail.getDetails().add(fd);
            }
        }
    }

    public QName getFaultcode() {
        return this.faultcode;
    }

    void setFaultcode(QName faultcode) {
        this.faultcode = faultcode;
    }

    public String getFaultString() {
        return this.faultstring;
    }

    void setFaultstring(String faultstring) {
        this.faultstring = faultstring;
    }

    public String getFaultactor() {
        return this.faultactor;
    }

    void setFaultactor(String faultactor) {
        this.faultactor = faultactor;
    }

    public DetailType getDetail() {
        return this.detail;
    }

    void setDetail(DetailType detail) {
        this.detail = detail;
    }
}

