/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wise.soap.fault;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.jboss.wise.soap.fault.CodeType;
import org.jboss.wise.soap.fault.DOMUtil;
import org.jboss.wise.soap.fault.DetailType;
import org.jboss.wise.soap.fault.ReasonType;
import org.jboss.wise.soap.fault.SubcodeType;
import org.jboss.wise.soap.fault.TextType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlRootElement(name="Fault", namespace="http://www.w3.org/2003/05/soap-envelope")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"code", "reason", "node", "role", "detail"})
public class SOAP12Fault {
    @XmlTransient
    private static final String ns = "http://www.w3.org/2003/05/soap-envelope";
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Code")
    private CodeType code;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Reason")
    private ReasonType reason;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Node")
    private String node;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Role")
    private String role;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Detail")
    private DetailType detail;

    public SOAP12Fault() {
    }

    public SOAP12Fault(CodeType code, ReasonType reason, String node, String role, DetailType detail) {
        this.code = code;
        this.reason = reason;
        this.node = node;
        this.role = role;
        this.detail = detail;
    }

    public SOAP12Fault(CodeType code, ReasonType reason, String node, String role, Element detailObject) {
        this.code = code;
        this.reason = reason;
        this.node = node;
        this.role = role;
        if (detailObject != null) {
            if (detailObject.getNamespaceURI().equals(ns) && detailObject.getLocalName().equals("Detail")) {
                this.detail = new DetailType();
                for (Element detailEntry : DOMUtil.getChildElements((Node)detailObject)) {
                    this.detail.getDetails().add(detailEntry);
                }
            } else {
                this.detail = new DetailType(detailObject);
            }
        }
    }

    public SOAP12Fault(QName code, String reason, Element detailObject) {
        this(new CodeType(code), new ReasonType(reason), null, null, detailObject);
    }

    public CodeType getCode() {
        return this.code;
    }

    public ReasonType getReason() {
        return this.reason;
    }

    public String getNode() {
        return this.node;
    }

    public String getRole() {
        return this.role;
    }

    public DetailType getDetail() {
        return this.detail;
    }

    void setDetail(DetailType detail) {
        this.detail = detail;
    }

    public String getFaultString() {
        return ((TextType)this.reason.texts().get(0)).getText();
    }

    private void fillFaultSubCodes(SOAPFault fault, SubcodeType subcode) throws SOAPException {
        if (subcode != null) {
            fault.appendFaultSubcode(subcode.getValue());
            this.fillFaultSubCodes(fault, subcode.getSubcode());
        }
    }
}

