/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.stack.cxf.client.HandlerResolverImpl;
import org.jboss.wsf.stack.cxf.client.ServiceRefStubPropertyServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceObjectFactory
implements ObjectFactory {
    protected final Logger log = Logger.getLogger(ServiceObjectFactory.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            Object target;
            Class<?> targetClass;
            BusFactory.setThreadDefaultBus(null);
            Reference ref = (Reference)obj;
            String targetClassName = (String)ref.get("TARGET_CLASS_NAME").getContent();
            UnifiedServiceRefMetaData serviceRef = this.unmarshallServiceRef(ref);
            String serviceRefName = serviceRef.getServiceRefName();
            QName serviceQName = serviceRef.getServiceQName();
            String serviceImplClass = serviceRef.getServiceImplClass();
            if (serviceImplClass == null) {
                serviceImplClass = (String)ref.get("SERVICE_CLASS_NAME").getContent();
            }
            if (Service.class.getName().equals(targetClassName)) {
                targetClassName = serviceImplClass;
            }
            this.log.debug((Object)("getObjectInstance [name=" + serviceRefName + ",service=" + serviceImplClass + ",target=" + targetClassName + "]"));
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> serviceClass = ctxLoader.loadClass(serviceImplClass);
            Class<?> clazz = targetClass = targetClassName != null ? ctxLoader.loadClass(targetClassName) : null;
            if (!Service.class.isAssignableFrom(serviceClass)) {
                throw new IllegalArgumentException("WebServiceRef type '" + serviceClass + "' is not assignable to javax.xml.ws.Service");
            }
            URL wsdlURL = serviceRef.getWsdlLocation();
            if (serviceClass == Service.class) {
                if (wsdlURL == null) throw new IllegalArgumentException("Cannot create generic javax.xml.ws.Service without wsdlLocation: " + serviceRefName);
                target = Service.create((URL)wsdlURL, (QName)serviceQName);
            } else if (wsdlURL != null) {
                Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class);
                target = ctor.newInstance(wsdlURL, serviceQName);
            } else {
                target = (Service)serviceClass.newInstance();
            }
            this.configureService((Service)target, serviceRef);
            if (targetClassName != null && !targetClassName.equals(serviceImplClass)) {
                try {
                    Object port = null;
                    if (serviceClass != Service.class) {
                        for (Method method : serviceClass.getDeclaredMethods()) {
                            String methodName = method.getName();
                            Class<?> retType = method.getReturnType();
                            if (!methodName.startsWith("get") || !targetClass.isAssignableFrom(retType)) continue;
                            target = port = method.invoke(target, new Object[0]);
                            break;
                        }
                    }
                    if (port == null) {
                        Method method = serviceClass.getMethod("getPort", Class.class);
                        target = port = method.invoke(target, targetClass);
                    }
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            if (serviceRef.getHandlerChain() != null && target instanceof Service) {
                Bus bus = BusFactory.getThreadDefaultBus();
                target.setHandlerResolver((HandlerResolver)new HandlerResolverImpl(bus, serviceRef.getHandlerChain(), target.getClass()));
            }
            this.hackServiceDelegate(target, serviceRef);
            return target;
        }
        catch (Throwable ex) {
            WSFException.rethrow((String)"Cannot create service", (Throwable)ex);
            return null;
        }
    }

    private Object hackServiceDelegate(final Object service, final UnifiedServiceRefMetaData serviceRef) throws Throwable {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Field delegateField = ServiceObjectFactory.findServiceDelegateField(service.getClass());
                        if (delegateField != null) {
                            delegateField.setAccessible(true);
                            ServiceDelegate delegate = (ServiceDelegate)delegateField.get(service);
                            delegateField.set(service, (Object)new ServiceRefStubPropertyServiceDelegate(delegate, serviceRef));
                            return delegate;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
        Field delegateField = ServiceObjectFactory.findServiceDelegateField(service.getClass());
        if (delegateField != null) {
            delegateField.setAccessible(true);
            ServiceDelegate delegate = (ServiceDelegate)delegateField.get(service);
            delegateField.set(service, (Object)new ServiceRefStubPropertyServiceDelegate(delegate, serviceRef));
            return delegate;
        }
        return null;
    }

    private static Field findServiceDelegateField(Class<?> clazz) {
        while (clazz != null) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getType().equals(ServiceDelegate.class)) continue;
                return f;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private void configureService(Service service, UnifiedServiceRefMetaData serviceRef) {
        this.log.warn((Object)"Service configuration not available in Apache-CXF");
    }

    private UnifiedServiceRefMetaData unmarshallServiceRef(Reference ref) throws ClassNotFoundException, NamingException {
        UnifiedServiceRefMetaData sref;
        RefAddr refAddr = ref.get("SERVICE_REF_META_DATA");
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])refAddr.getContent());
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
        }
        return sref;
    }
}

