/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Map;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.binding.JAXBBindingCustomization;

public class JBossWSCXFConfigurer
implements Configurer {
    private BindingCustomization customization;
    private Configurer delegate;

    public JBossWSCXFConfigurer(Configurer delegate) {
        this.delegate = delegate;
    }

    public void setBindingCustomization(BindingCustomization customization) {
        this.customization = customization;
    }

    public void configureBean(Object beanInstance) {
        if (beanInstance instanceof AbstractWSDLBasedEndpointFactory) {
            this.configureEndpointFactory((AbstractWSDLBasedEndpointFactory)beanInstance);
        } else if (beanInstance instanceof ClientProxyFactoryBean) {
            this.configureClientProxyFactoryBean((ClientProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(beanInstance);
        }
    }

    public void configureBean(String name, Object beanInstance) {
        if (beanInstance instanceof AbstractWSDLBasedEndpointFactory) {
            this.configureEndpointFactory((AbstractWSDLBasedEndpointFactory)beanInstance);
        } else if (beanInstance instanceof ClientProxyFactoryBean) {
            this.configureClientProxyFactoryBean((ClientProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(name, beanInstance);
        }
    }

    protected synchronized void configureEndpointFactory(AbstractWSDLBasedEndpointFactory factory) {
        if (this.customization != null) {
            JBossWSCXFConfigurer.setBindingCustomization(factory.getServiceFactory().getDataBinding(), this.customization);
            JBossWSCXFConfigurer.setBindingCustomization(factory.getDataBinding(), this.customization);
        }
    }

    protected synchronized void configureClientProxyFactoryBean(ClientProxyFactoryBean factory) {
        if (this.customization != null) {
            JBossWSCXFConfigurer.setBindingCustomization(factory.getServiceFactory().getDataBinding(), this.customization);
            JBossWSCXFConfigurer.setBindingCustomization(factory.getDataBinding(), this.customization);
        }
    }

    protected static void setBindingCustomization(DataBinding db, BindingCustomization customization) {
        if (customization instanceof JAXBBindingCustomization && db != null && db instanceof JAXBDataBinding) {
            ((JAXBDataBinding)db).setContextProperties((Map)customization);
        }
    }
}

