/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Map;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.binding.JAXBBindingCustomization;

public class JBossWSCXFConfigurer
extends ConfigurerImpl {
    protected BindingCustomization customization;

    public void configureBean(Object beanInstance) {
        this.customConfigure(beanInstance);
        super.configureBean(beanInstance);
    }

    public void configureBean(String name, Object beanInstance) {
        this.customConfigure(beanInstance);
        super.configureBean(name, beanInstance);
    }

    protected void customConfigure(Object beanInstance) {
        if (beanInstance instanceof AbstractWSDLBasedEndpointFactory) {
            this.configureEndpointFactory((AbstractWSDLBasedEndpointFactory)beanInstance);
        } else if (beanInstance instanceof ClientProxyFactoryBean) {
            this.configureClientProxyFactoryBean((ClientProxyFactoryBean)beanInstance);
        } else if (beanInstance instanceof HTTPConduit) {
            this.configureHTTPConduit((HTTPConduit)beanInstance);
        }
    }

    protected synchronized void configureEndpointFactory(AbstractWSDLBasedEndpointFactory factory) {
        if (this.customization != null) {
            ReflectionServiceFactoryBean serviceFactory = factory.getServiceFactory();
            serviceFactory.reset();
            DataBinding serviceFactoryDataBinding = serviceFactory.getDataBinding(true);
            JBossWSCXFConfigurer.configureBindingCustomization(serviceFactoryDataBinding, this.customization);
            serviceFactory.setDataBinding(serviceFactoryDataBinding);
            if (factory.getDataBinding() == null) {
                factory.setDataBinding(serviceFactoryDataBinding);
            } else {
                JBossWSCXFConfigurer.configureBindingCustomization(factory.getDataBinding(), this.customization);
            }
        }
    }

    protected synchronized void configureClientProxyFactoryBean(ClientProxyFactoryBean factory) {
        if (this.customization != null) {
            ReflectionServiceFactoryBean serviceFactory = factory.getServiceFactory();
            serviceFactory.reset();
            DataBinding serviceFactoryDataBinding = serviceFactory.getDataBinding(true);
            JBossWSCXFConfigurer.configureBindingCustomization(serviceFactoryDataBinding, this.customization);
            serviceFactory.setDataBinding(serviceFactoryDataBinding);
            if (factory.getDataBinding() == null) {
                factory.setDataBinding(serviceFactoryDataBinding);
            } else {
                JBossWSCXFConfigurer.configureBindingCustomization(factory.getDataBinding(), this.customization);
            }
        }
    }

    protected synchronized void configureHTTPConduit(HTTPConduit conduit) {
        TLSClientParameters parameters = conduit.getTlsClientParameters();
        if (parameters == null) {
            parameters = new TLSClientParameters();
            parameters.setUseHttpsURLConnectionDefaultSslSocketFactory(true);
            if (Boolean.getBoolean("org.jboss.security.ignoreHttpsHost")) {
                parameters.setDisableCNCheck(true);
            }
            conduit.setTlsClientParameters(parameters);
        }
    }

    protected static void configureBindingCustomization(DataBinding db, BindingCustomization customization) {
        if (customization instanceof JAXBBindingCustomization && db != null && db instanceof JAXBDataBinding) {
            ((JAXBDataBinding)db).setContextProperties((Map)customization);
        }
    }

    public void setBindingCustomization(BindingCustomization customization) {
        this.customization = customization;
    }
}

