/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.cxf.common.util.Compiler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.wsf.stack.cxf.i18n.Loggers;
import org.jboss.wsf.stack.cxf.tools.JavaFileObjectImpl;

public final class Jdk9PlusJBossModulesAwareCompiler
extends Compiler {
    private static final String UFS = "/";

    public boolean compileFiles(String[] files) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new IllegalStateException("No compiler detected, make sure you are running on top of a JDK instead of a JRE.");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> fileList = fileManager.getJavaFileObjectsFromStrings(Arrays.asList(files));
        return this.internalCompile(compiler, this.wrapJavaFileManager(fileManager), this.setupDiagnosticListener(), fileList);
    }

    protected boolean internalCompile(JavaCompiler compiler, JavaFileManager fileManager, DiagnosticListener<JavaFileObject> listener, Iterable<? extends JavaFileObject> fileList) {
        ArrayList<String> args = new ArrayList<String>();
        this.addArgs(args);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, listener, args, null, fileList);
        Boolean ret = task.call();
        try {
            fileManager.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected JavaFileManager wrapJavaFileManager(StandardJavaFileManager standardJavaFileManger) {
        return new Jdk9PlusCustomJavaFileManager(standardJavaFileManger);
    }

    class JBossModulePathFilter
    implements PathFilter {
        private final String path;

        public JBossModulePathFilter(String path) {
            this.path = path;
        }

        public boolean accept(String p) {
            return p.startsWith(this.path);
        }

        public boolean equals(Object obj) {
            return obj instanceof JBossModulePathFilter && this.equals((JBossModulePathFilter)obj);
        }

        public boolean equals(JBossModulePathFilter obj) {
            return obj != null && obj.path.equals(this.path);
        }

        public int hashcode() {
            return this.path.hashCode();
        }
    }

    final class Jdk9PlusCustomJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private ClassLoader moduleclassLoader;

        protected Jdk9PlusCustomJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
            this.moduleclassLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.moduleclassLoader;
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            return super.getFileForInput(location, packageName, relativeName);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
            String result = file instanceof JavaFileObjectImpl ? file.getName() : super.inferBinaryName(loc, file);
            return result;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
            ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            if (location == StandardLocation.CLASS_PATH && !result.iterator().hasNext()) {
                Module module = Module.forClassLoader((ClassLoader)this.moduleclassLoader, (boolean)true);
                if (module == null) {
                    Loggers.ROOT_LOGGER.couldNotLoadJBossModuleForClassloader(this.moduleclassLoader.toString());
                } else {
                    try {
                        String pathName = packageName.replace(".", Jdk9PlusJBossModulesAwareCompiler.UFS);
                        Iterator resIt = module.iterateResources((PathFilter)new JBossModulePathFilter(pathName));
                        while (resIt.hasNext()) {
                            Resource r = (Resource)resIt.next();
                            String n = r.getName();
                            int indx = n.lastIndexOf(".class");
                            if (indx <= 0) continue;
                            String n1 = n.replace(Jdk9PlusJBossModulesAwareCompiler.UFS, ".");
                            String clazzName = n1.substring(0, indx);
                            files.add(new JavaFileObjectImpl(clazzName, this.moduleclassLoader));
                        }
                    }
                    catch (ModuleLoadException mle) {
                        Loggers.ROOT_LOGGER.debug("", mle);
                    }
                    catch (Exception e) {
                        Loggers.ROOT_LOGGER.warn("", e);
                    }
                }
            } else {
                for (JavaFileObject file : result) {
                    files.add(file);
                }
            }
            return files;
        }
    }
}

