/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public class ServletControllerExt
extends ServletController {
    private ServletTransportFactory cxfTransport;
    private ServletContext servletCtx;
    private Bus bus;
    private ServerConfig serverConfig;

    public ServletControllerExt(ServletTransportFactory cxfTransport, ServletConfig config, ServletContext servletCtx, Bus bus) {
        super(cxfTransport, config, servletCtx, bus);
        this.cxfTransport = cxfTransport;
        this.servletCtx = servletCtx;
        this.bus = bus;
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
    }

    private ServletDestination findDestination(HttpServletRequest req) throws ServletException {
        String requestURI = req.getRequestURI();
        Collection destinations = this.cxfTransport.getDestinations();
        Object exactMatch = null;
        ServletDestination returnValue = null;
        for (ServletDestination destination : destinations) {
            String address;
            EndpointInfo endpointInfo = destination.getEndpointInfo();
            String path = address = endpointInfo.getAddress();
            try {
                path = new URL(address).getPath();
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (path == null) continue;
            if (requestURI.equals(path)) {
                return destination;
            }
            if (!requestURI.startsWith(path)) continue;
            returnValue = destination;
        }
        if (returnValue == null) {
            throw new ServletException("Cannot obtain destination for: " + requestURI);
        }
        return returnValue;
    }

    private boolean handleQuery(HttpServletRequest req, HttpServletResponse res, ServletDestination dest) throws ServletException {
        boolean queryHandlerRegistryExists;
        boolean hasQuery = null != req.getQueryString() && req.getQueryString().length() > 0;
        boolean bl = queryHandlerRegistryExists = this.bus.getExtension(QueryHandlerRegistry.class) != null;
        if (hasQuery && queryHandlerRegistryExists) {
            String ctxUri = req.getRequestURI();
            String baseUri = req.getRequestURL().toString() + "?" + req.getQueryString();
            EndpointInfo endpointInfo = dest.getEndpointInfo();
            if ("jbossws.undefined.host".equals(this.serverConfig.getWebServiceHost())) {
                endpointInfo.setProperty("autoRewriteSoapAddress", (Object)true);
            }
            for (QueryHandler queryHandler : ((QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
                if (!queryHandler.isRecognizedQuery(baseUri, ctxUri, endpointInfo)) continue;
                res.setContentType(queryHandler.getResponseContentType(baseUri, ctxUri));
                try {
                    ServletOutputStream out = res.getOutputStream();
                    queryHandler.writeResponse(baseUri, ctxUri, endpointInfo, (OutputStream)out);
                    out.flush();
                    return true;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
        return false;
    }

    public void invoke(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ServletDestination dest = this.findDestination(req);
        boolean requestHandled = this.handleQuery(req, res, dest);
        if (!requestHandled) {
            this.invokeDestination(req, res, dest);
        }
    }
}

