/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.jms;

import java.io.InputStream;
import java.net.URL;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class JMSEndpointsFactory
implements ObjectModelFactory {
    private URL descriptorURL;

    public JMSEndpointsFactory(URL descriptorURL) {
        this.descriptorURL = descriptorURL;
    }

    public static JMSEndpointsMetaData load(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            JMSEndpointsFactory factory = new JMSEndpointsFactory(url);
            JMSEndpointsMetaData jMSEndpointsMetaData = (JMSEndpointsMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            return jMSEndpointsMetaData;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return new JMSEndpointsMetaData(this.descriptorURL);
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(JMSEndpointsMetaData endpoints, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("endpoint".equals(localName) && this.isJMSEndpoint(attrs)) {
            JMSEndpointMetaData endpoint = new JMSEndpointMetaData(endpoints);
            endpoint.setName(attrs.getValue("name"));
            endpoint.setImplementor(attrs.getValue("implementor"));
            endpoint.setEndpointName(attrs.getValue("endpointName"));
            endpoint.setWsdlLocation(attrs.getValue("wsdlLocation"));
            return endpoint;
        }
        return null;
    }

    private boolean isJMSEndpoint(Attributes attrs) {
        if (attrs == null) {
            return false;
        }
        if (attrs.getValue("transportId") == null) {
            return false;
        }
        return attrs.getValue("transportId").equals("http://cxf.apache.org/transports/jms");
    }

    public void addChild(JMSEndpointsMetaData endpoints, JMSEndpointMetaData endpointMetaData, UnmarshallingContext navigator, String namespaceURI, String localName) {
        endpoints.addEndpointMetaData(endpointMetaData);
    }
}

