/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.spring.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

public class NamespaceHandlerResolver
extends DefaultNamespaceHandlerResolver {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NamespaceHandlerResolver.class);
    public static final String JBOSSWS_HANDLER_MAPPINGS_LOCATION = "META-INF/jbossws.spring.handlers";
    private static final Logger logger = Logger.getLogger(NamespaceHandlerResolver.class);
    private ClassLoader loader;
    private Map<Object, Object> jbosswsHandlerMappings;

    public NamespaceHandlerResolver() {
    }

    public NamespaceHandlerResolver(ClassLoader classLoader) {
        super(classLoader);
        this.loader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public NamespaceHandlerResolver(ClassLoader classLoader, String handlerMappingsLocation) {
        super(classLoader, handlerMappingsLocation);
        this.loader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public NamespaceHandler resolve(String namespaceUri) {
        NamespaceHandler jbosswsHandler;
        block2: {
            jbosswsHandler = null;
            try {
                jbosswsHandler = this.resolveInternal(namespaceUri);
            }
            catch (Throwable t) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace((Object)("Unable to resolve JBossWS specific handler for namespace '" + namespaceUri + "'; trying default namespace resolution..."), t);
            }
        }
        return jbosswsHandler != null ? jbosswsHandler : super.resolve(namespaceUri);
    }

    private NamespaceHandler resolveInternal(String namespaceUri) {
        Map<Object, Object> handlerMappings = this.getHandlerMappings();
        Object handlerOrClassName = handlerMappings.get(namespaceUri);
        if (handlerOrClassName == null) {
            return null;
        }
        if (handlerOrClassName instanceof NamespaceHandler) {
            return (NamespaceHandler)handlerOrClassName;
        }
        String className = (String)handlerOrClassName;
        try {
            Class handlerClass = ClassUtils.forName((String)className, (ClassLoader)this.loader);
            if (!NamespaceHandler.class.isAssignableFrom(handlerClass)) {
                throw new FatalBeanException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_IMPLEMENT_NSHANDLER_INTERFACE", (Object[])new Object[]{className, namespaceUri, NamespaceHandler.class.getName()}));
            }
            NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass((Class)handlerClass);
            namespaceHandler.init();
            handlerMappings.put(namespaceUri, namespaceHandler);
            return namespaceHandler;
        }
        catch (ClassNotFoundException ex) {
            throw new FatalBeanException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NSHANDLER_CLASS_NOT_FOUND", (Object[])new Object[]{className, namespaceUri}), (Throwable)ex);
        }
        catch (LinkageError err) {
            throw new FatalBeanException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NAMESPACEHANDLER_CLASS", (Object[])new Object[]{className, namespaceUri}), (Throwable)err);
        }
    }

    private Map<Object, Object> getHandlerMappings() {
        if (this.jbosswsHandlerMappings == null) {
            try {
                Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)JBOSSWS_HANDLER_MAPPINGS_LOCATION, (ClassLoader)this.loader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loaded mappings [" + mappings + "]"));
                }
                this.jbosswsHandlerMappings = new HashMap<Object, Object>(mappings);
            }
            catch (IOException ex) {
                IllegalStateException ise = new IllegalStateException("Unable to load NamespaceHandler mappings from location [META-INF/jbossws.spring.handlers]");
                ise.initCause(ex);
                throw ise;
            }
        }
        return this.jbosswsHandlerMappings;
    }
}

