/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addressRewrite;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.addressRewrite.SEDProcessor;

public class SoapAddressRewriteHelper {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    public static String getRewrittenPublishedEndpointUrl(String wsdlAddress, String epAddress, ServerConfig serverConfig, Map<String, String> props) {
        if (wsdlAddress == null) {
            return null;
        }
        if (SoapAddressRewriteHelper.isRewriteRequired(serverConfig, wsdlAddress)) {
            String origUriScheme = SoapAddressRewriteHelper.getUriScheme(wsdlAddress);
            String newUriScheme = SoapAddressRewriteHelper.getUriScheme(epAddress);
            return SoapAddressRewriteHelper.rewriteSoapAddress(serverConfig, wsdlAddress, epAddress, SoapAddressRewriteHelper.rewriteUriScheme(origUriScheme, newUriScheme, serverConfig, props));
        }
        return wsdlAddress;
    }

    public static String getRewrittenPublishedEndpointUrl(String address, ServerConfig serverConfig, Map<String, String> props) {
        try {
            if (SoapAddressRewriteHelper.isPathRewriteRequired(serverConfig) || SoapAddressRewriteHelper.isSchemeRewriteRequired(serverConfig, props)) {
                URL url = new URL(address);
                String uriScheme = SoapAddressRewriteHelper.rewriteUriScheme(SoapAddressRewriteHelper.getUriScheme(address), null, serverConfig, props);
                String port = SoapAddressRewriteHelper.getDotPortNumber(uriScheme, serverConfig);
                StringBuilder builder = new StringBuilder();
                builder.append(uriScheme);
                builder.append("://");
                builder.append(url.getHost());
                builder.append(port);
                String path = url.getPath();
                builder.append(SoapAddressRewriteHelper.isPathRewriteRequired(serverConfig) ? SEDProcessor.newInstance(serverConfig.getWebServicePathRewriteRule()).processLine(path) : path);
                String newUrl = builder.toString();
                Loggers.ADDRESS_REWRITE_LOGGER.addressRewritten(address, newUrl);
                return newUrl;
            }
            Loggers.ADDRESS_REWRITE_LOGGER.rewriteNotRequired(address);
            return address;
        }
        catch (MalformedURLException e) {
            Loggers.ADDRESS_REWRITE_LOGGER.invalidAddressProvidedUseItWithoutRewriting(address, "");
            return address;
        }
    }

    public static boolean isAutoRewriteOn(ServerConfig serverConfig) {
        return serverConfig.isModifySOAPAddress() && "jbossws.undefined.host".equals(serverConfig.getWebServiceHost());
    }

    private static boolean isRewriteRequired(ServerConfig serverConfig, String address) {
        if (serverConfig.isModifySOAPAddress()) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfServerConf(address);
            return true;
        }
        if (SoapAddressRewriteHelper.isInvalidAddress(address)) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfInvalidAddress(address);
            return true;
        }
        Loggers.ADDRESS_REWRITE_LOGGER.rewriteNotRequired(address);
        return false;
    }

    private static boolean isInvalidAddress(String address) {
        if (address == null) {
            return true;
        }
        String s = address.trim();
        if (s.length() == 0 || s.contains("REPLACE_WITH_ACTUAL_URL")) {
            return true;
        }
        try {
            new URL(s);
        }
        catch (MalformedURLException e) {
            return true;
        }
        return false;
    }

    private static String rewriteSoapAddress(ServerConfig serverConfig, String origAddress, String newAddress, String uriScheme) {
        try {
            URL url = new URL(newAddress);
            String path = url.getPath();
            String host = serverConfig.getWebServiceHost();
            String port = SoapAddressRewriteHelper.getDotPortNumber(uriScheme, serverConfig);
            StringBuilder sb = new StringBuilder(uriScheme);
            sb.append("://");
            sb.append(host);
            sb.append(port);
            if (SoapAddressRewriteHelper.isPathRewriteRequired(serverConfig)) {
                sb.append(SEDProcessor.newInstance(serverConfig.getWebServicePathRewriteRule()).processLine(path));
            } else {
                sb.append(path);
            }
            String urlStr = sb.toString();
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewritten(origAddress, urlStr);
            return urlStr;
        }
        catch (MalformedURLException e) {
            Loggers.ADDRESS_REWRITE_LOGGER.invalidAddressProvidedUseItWithoutRewriting(newAddress, origAddress);
            return origAddress;
        }
    }

    private static String getDotPortNumber(String uriScheme, ServerConfig serverConfig) {
        String port = "";
        if (HTTPS.equals(uriScheme)) {
            int portNo = serverConfig.getWebServiceSecurePort();
            if (portNo != 443) {
                port = ":" + portNo;
            }
        } else {
            int portNo = serverConfig.getWebServicePort();
            if (portNo != 80) {
                port = ":" + portNo;
            }
        }
        return port;
    }

    private static String getUriScheme(String address) {
        try {
            URI addrURI = new URI(address);
            String scheme = addrURI.getScheme();
            return scheme != null ? scheme : HTTP;
        }
        catch (URISyntaxException e) {
            return HTTP;
        }
    }

    public static boolean isPathRewriteRequired(ServerConfig sc) {
        if (!sc.isModifySOAPAddress()) {
            return false;
        }
        String pathRewriteRule = sc.getWebServicePathRewriteRule();
        return pathRewriteRule != null && !pathRewriteRule.isEmpty();
    }

    public static boolean isSchemeRewriteRequired(ServerConfig sc, Map<String, String> props) {
        if (!sc.isModifySOAPAddress()) {
            return false;
        }
        return sc.getWebServiceUriScheme() != null || props.get("org.jboss.ws.cxf.wsdl.uriScheme") != null;
    }

    private static String rewriteUriScheme(String origUriScheme, String newUriScheme, ServerConfig serverConfig, Map<String, String> props) {
        String mdUriScheme;
        String uriScheme = HTTPS.equals(origUriScheme) || HTTPS.equals(newUriScheme) ? HTTPS : HTTP;
        String serverUriScheme = serverConfig.getWebServiceUriScheme();
        if (serverUriScheme != null) {
            uriScheme = serverUriScheme;
        }
        if ((mdUriScheme = props.get("org.jboss.ws.cxf.wsdl.uriScheme")) != null) {
            uriScheme = mdUriScheme;
        }
        return uriScheme;
    }
}

