/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInvokerInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageOutInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.cxf.staxutils.XMLStreamReaderWrapper;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.discovery.listeners.WSDiscoveryServerListener;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.selector.MaximalAlternativeSelector;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLManagerImpl;
import org.jboss.ws.api.annotation.PolicySets;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.AnnotationsInfo;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.configuration.SysPropExpandingStreamReader;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicySetsAnnotationListener;
import org.jboss.wsf.stack.cxf.interceptor.EnableDecoupledFaultInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.EndpointAssociationInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.HandlerAuthInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.NsCtxSelectorStoreInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.WSDLSoapAddressRewriteInterceptor;
import org.jboss.wsf.stack.cxf.management.InstrumentationManagerExtImpl;
import org.jboss.wsf.stack.cxf.security.authentication.AuthenticationMgrSubjectCreatingInterceptor;

public abstract class BusHolder {
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    public static final String PARAM_CXF_GEN_URL = "jbossws.cxf.gen.url";
    protected Bus bus;
    protected BusHolderLifeCycleListener busHolderListener;
    protected FactoryBeanListener policySetsListener;

    public BusHolder() {
    }

    public BusHolder(Bus bus) {
        this.setBus(bus);
    }

    public void configure(ResourceResolver resolver, Configurer configurer, JBossWebservicesMetaData wsmd, Deployment dep) {
        this.bus.setProperty("deployment-bus", (Object)true);
        this.busHolderListener = new BusHolderLifeCycleListener();
        ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this.busHolderListener);
        BusHolder.setWSDLManagerStreamWrapper(this.bus);
        if (configurer != null) {
            this.bus.setExtension((Object)configurer, Configurer.class);
        }
        Map<String, String> props = BusHolder.getProperties(wsmd);
        this.setInterceptors(this.bus, props);
        dep.addAttachment(Bus.class, (Object)this.bus);
        try {
            JASPIAuthenticationProvider jaspiProvider = (JASPIAuthenticationProvider)SPIProvider.getInstance().getSPI(JASPIAuthenticationProvider.class, ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            if (jaspiProvider != null && jaspiProvider.enableServerAuthentication(dep, wsmd)) {
                this.bus.getInInterceptors().add(new AuthenticationMgrSubjectCreatingInterceptor());
            }
        }
        catch (WSFException e) {
            Loggers.DEPLOYMENT_LOGGER.cannotFindJaspiClasses();
        }
        BusHolder.setResourceResolver(this.bus, resolver);
        if (this.bus.getExtension(PolicyEngine.class) != null) {
            ((PolicyEngine)this.bus.getExtension(PolicyEngine.class)).setAlternativeSelector(BusHolder.getAlternativeSelector(props));
        }
        BusHolder.setCXFManagement(this.bus, props);
        BusHolder.setAdditionalWorkQueues(this.bus, props);
        BusHolder.setWSDiscovery(this.bus, props);
        AnnotationsInfo ai = (AnnotationsInfo)dep.getAttachment(AnnotationsInfo.class);
        if (ai == null || ai.hasAnnotatedClasses(new String[]{PolicySets.class.getName()})) {
            this.policySetsListener = new PolicySetsAnnotationListener(dep.getClassLoader());
            ((FactoryBeanListenerManager)this.bus.getExtension(FactoryBeanListenerManager.class)).addListener(this.policySetsListener);
        }
    }

    private static Map<String, String> getProperties(JBossWebservicesMetaData wsmd) {
        Map props = wsmd != null ? wsmd.getProperties() : Collections.emptyMap();
        return props;
    }

    public void close() {
        if (this.busHolderListener == null || !this.busHolderListener.isPreShutdown()) {
            this.bus.shutdown(true);
        }
        this.busHolderListener = null;
        ((FactoryBeanListenerManager)this.bus.getExtension(FactoryBeanListenerManager.class)).removeListener(this.policySetsListener);
        this.policySetsListener = null;
    }

    public abstract Configurer createServerConfigurer(BindingCustomization var1, WSDLFilePublisher var2, List<Endpoint> var3, UnifiedVirtualFile var4, String var5, String var6);

    protected void setInterceptors(Bus bus, Map<String, String> props) {
        ServerConfig sc;
        String p;
        bus.getInInterceptors().add(new EndpointAssociationInterceptor());
        bus.getInInterceptors().add(new EnableDecoupledFaultInterceptor());
        bus.getInInterceptors().add(new NsCtxSelectorStoreInterceptor());
        String string = p = props != null ? props.get("org.jboss.ws.cxf.disableHandlerAuthChecks") : null;
        if (!(p != null && ("true".equalsIgnoreCase(p) || "1".equalsIgnoreCase(p)) || Boolean.getBoolean("org.jboss.ws.cxf.disableHandlerAuthChecks"))) {
            bus.getInInterceptors().add(new HandlerAuthInterceptor());
        }
        if (SoapAddressRewriteHelper.isPathRewriteRequired(sc = this.getServerConfig()) || SoapAddressRewriteHelper.isSchemeRewriteRequired(sc, props)) {
            bus.getInInterceptors().add(new WSDLSoapAddressRewriteInterceptor(props));
        }
    }

    protected static void setResourceResolver(Bus bus, ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            ((ResourceManager)bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
    }

    protected static void setAdditionalWorkQueues(Bus bus, Map<String, String> props) {
        if (props != null && !props.isEmpty()) {
            HashMap<String, HashMap<String, String>> queuesMap = new HashMap<String, HashMap<String, String>>();
            for (Map.Entry<String, String> e : props.entrySet()) {
                String sk;
                int i;
                String k = e.getKey();
                if (!k.startsWith("cxf.queue.") || (i = (sk = k.substring("cxf.queue.".length())).indexOf(".")) <= 0) continue;
                String queueName = sk.substring(0, i);
                String queueProp = sk.substring(i + 1);
                HashMap<String, String> m = (HashMap<String, String>)queuesMap.get(queueName);
                if (m == null) {
                    m = new HashMap<String, String>();
                    queuesMap.put(queueName, m);
                }
                m.put(queueProp, e.getValue());
            }
            WorkQueueManager mgr = (WorkQueueManager)bus.getExtension(WorkQueueManager.class);
            for (Map.Entry e : queuesMap.entrySet()) {
                String queueName = (String)e.getKey();
                AutomaticWorkQueue q = BusHolder.createWorkQueue(queueName, (Map)e.getValue());
                mgr.addNamedWorkQueue(queueName, q);
            }
        }
    }

    protected static void setCXFManagement(Bus bus, Map<String, String> props) {
        String p;
        if (props != null && !props.isEmpty() && ("true".equalsIgnoreCase(p = props.get("cxf.management.enabled")) || "1".equalsIgnoreCase(p))) {
            InstrumentationManagerExtImpl instrumentationManagerImpl = new InstrumentationManagerExtImpl();
            instrumentationManagerImpl.setBus(bus);
            instrumentationManagerImpl.setEnabled(true);
            instrumentationManagerImpl.initMBeanServer();
            instrumentationManagerImpl.register();
            bus.setExtension((Object)instrumentationManagerImpl, InstrumentationManager.class);
            CounterRepository couterRepository = new CounterRepository();
            couterRepository.setBus(bus);
            String installRespTimeInterceptors = props.get("cxf.management.installResponseTimeInterceptors");
            if (installRespTimeInterceptors == null || "true".equalsIgnoreCase(installRespTimeInterceptors) || "1".equalsIgnoreCase(installRespTimeInterceptors)) {
                ResponseTimeMessageInInterceptor in = new ResponseTimeMessageInInterceptor();
                ResponseTimeMessageInvokerInterceptor invoker = new ResponseTimeMessageInvokerInterceptor();
                ResponseTimeMessageOutInterceptor out = new ResponseTimeMessageOutInterceptor();
                bus.getInInterceptors().add(in);
                bus.getInInterceptors().add(invoker);
                bus.getOutInterceptors().add(out);
            }
            bus.setExtension((Object)couterRepository, CounterRepository.class);
        }
    }

    protected static void setWSDiscovery(Bus bus, Map<String, String> props) {
        String p;
        if (props != null && !props.isEmpty() && ("true".equalsIgnoreCase(p = props.get("cxf.ws-discovery.enabled")) || "1".equalsIgnoreCase(p))) {
            ((ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class)).registerListener((ServerLifeCycleListener)new WSDiscoveryServerListener(bus));
        }
    }

    private static void setWSDLManagerStreamWrapper(Bus bus) {
        ((WSDLManagerImpl)bus.getExtension(WSDLManager.class)).setXMLStreamReaderWrapper(new XMLStreamReaderWrapper(){

            public XMLStreamReader wrap(XMLStreamReader reader) {
                return new SysPropExpandingStreamReader(reader);
            }
        });
    }

    private static AlternativeSelector getAlternativeSelector(Map<String, String> props) {
        String className;
        MaximalAlternativeSelector selector = new MaximalAlternativeSelector();
        if (props != null && !props.isEmpty() && (className = props.get("cxf.policy.alternativeSelector")) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                selector = (AlternativeSelector)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return selector;
    }

    private static AutomaticWorkQueue createWorkQueue(String name, Map<String, String> props) {
        int mqs = BusHolder.parseInt(props.get("maxQueueSize"), 256);
        int initialThreads = BusHolder.parseInt(props.get("initialThreads"), 0);
        int highWaterMark = BusHolder.parseInt(props.get("highWaterMark"), 25);
        int lowWaterMark = BusHolder.parseInt(props.get("lowWaterMark"), 5);
        long dequeueTimeout = BusHolder.parseLong(props.get("dequeueTimeout"), 120000L);
        return new AutomaticWorkQueueImpl(mqs, initialThreads, highWaterMark, lowWaterMark, dequeueTimeout, name);
    }

    private static int parseInt(String prop, int defaultValue) {
        return prop != null ? Integer.parseInt(prop) : defaultValue;
    }

    private static long parseLong(String prop, long defaultValue) {
        return prop != null ? Long.parseLong(prop) : defaultValue;
    }

    protected ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return (ServerConfig)AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }

    public Bus getBus() {
        return this.bus;
    }

    protected void setBus(Bus bus) {
        this.bus = bus;
    }

    private static class BusHolderLifeCycleListener
    implements BusLifeCycleListener {
        private volatile boolean preShutdown = false;

        private BusHolderLifeCycleListener() {
        }

        public boolean isPreShutdown() {
            return this.preShutdown;
        }

        public void initComplete() {
        }

        public void preShutdown() {
            this.preShutdown = true;
        }

        public void postShutdown() {
        }
    }
}

