/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.interceptor.util;

import java.security.AccessController;
import java.util.Map;
import javax.wsdl.Definition;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;

public class WSDLSoapAddressRewriteUtils
extends WSDLGetUtils {
    private final Map<String, String> props;

    public WSDLSoapAddressRewriteUtils(Map<String, String> props) {
        this.props = props;
    }

    public String getPublishableEndpointUrl(Definition def, String epurl, EndpointInfo endpointInfo) {
        if (endpointInfo.getProperty("publishedEndpointUrl") != null) {
            epurl = String.valueOf(endpointInfo.getProperty("publishedEndpointUrl"));
            this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
        } else {
            ServerConfig sc = WSDLSoapAddressRewriteUtils.getServerConfig();
            if ((SoapAddressRewriteHelper.isPathRewriteRequired(sc) || SoapAddressRewriteHelper.isSchemeRewriteRequired(sc, this.props)) && endpointInfo.getAddress().contains("jbossws.undefined.host")) {
                epurl = SoapAddressRewriteHelper.getRewrittenPublishedEndpointUrl(epurl, sc, this.props);
                this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
            }
        }
        return epurl;
    }

    private static ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return (ServerConfig)AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }
}

