/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreator;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;

public class SubjectCreatingInterceptor
extends WSS4JInInterceptor {
    protected final SubjectCreator helper = new SubjectCreator();
    private static final Logger LOG = LogUtils.getL7dLogger(SubjectCreatingInterceptor.class);
    private final ThreadLocal<SecurityDomainContext> sdc = new ThreadLocal();
    private boolean supportDigestPasswords;

    public SubjectCreatingInterceptor() {
        this(new HashMap<String, Object>());
    }

    public SubjectCreatingInterceptor(Map<String, Object> properties) {
        super(properties);
        this.getAfter().add(PolicyBasedWSS4JInInterceptor.class.getName());
    }

    public void setSupportDigestPasswords(boolean support) {
        this.supportDigestPasswords = support;
    }

    public boolean getSupportDigestPasswords() {
        return this.supportDigestPasswords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SoapMessage msg) throws Fault {
        Endpoint ep = (Endpoint)msg.getExchange().get(Endpoint.class);
        this.sdc.set(ep.getSecurityDomainContext());
        try {
            SecurityToken token = (SecurityToken)msg.get(SecurityToken.class);
            SecurityContext context = (SecurityContext)msg.get(SecurityContext.class);
            if (token == null || context == null || context.getUserPrincipal() == null) {
                super.handleMessage(msg);
                return;
            }
            UsernameToken ut = (UsernameToken)token;
            Subject subject = this.createSubject(ut.getName(), ut.getPassword(), ut.isHashed(), ut.getNonce(), ut.getCreatedTime(), (Message)msg);
            SecurityContext sc = this.doCreateSecurityContext(context.getUserPrincipal(), subject);
            msg.put(SecurityContext.class, (Object)sc);
        }
        finally {
            if (this.sdc != null) {
                this.sdc.remove();
            }
        }
    }

    protected SecurityContext createSecurityContext(Principal p) {
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        if (msg == null) {
            throw new IllegalStateException("Current message is not available");
        }
        return this.doCreateSecurityContext(p, (Subject)msg.get(Subject.class));
    }

    protected SecurityContext doCreateSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    protected void setSubject(String name, String password, boolean isDigest, String nonce, String created) throws WSSecurityException {
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        if (msg == null) {
            throw new IllegalStateException("Current message is not available");
        }
        Subject subject = null;
        try {
            subject = this.createSubject(name, password, isDigest, nonce, created, msg);
        }
        catch (Exception ex) {
            String errorMessage = "Failed Authentication : Subject has not been created";
            LOG.severe(errorMessage);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (subject == null || subject.getPrincipals().size() == 0 || !this.checkUserPrincipal(subject.getPrincipals(), name)) {
            String errorMessage = "Failed Authentication : Invalid Subject";
            LOG.severe(errorMessage);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        msg.put(Subject.class, (Object)subject);
    }

    private boolean checkUserPrincipal(Set<Principal> principals, String name) {
        for (Principal p : principals) {
            if (p instanceof Group) continue;
            return p.getName().equals(name);
        }
        return false;
    }

    protected WSSecurityEngine getSecurityEngine(boolean utNoCallbacks) {
        HashMap<QName, CustomValidator> profiles = new HashMap<QName, CustomValidator>(1);
        CustomValidator validator = new CustomValidator();
        profiles.put(WSSecurityEngine.USERNAME_TOKEN, validator);
        return SubjectCreatingInterceptor.createSecurityEngine(profiles);
    }

    public Subject createSubject(String name, String password, boolean isDigest, String nonce, String created, Message msg) {
        return this.helper.createSubject(this.sdc.get(), name, password, isDigest, nonce, created, msg);
    }

    public void setPropagateContext(boolean propagateContext) {
        this.helper.setPropagateContext(propagateContext);
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.helper.setTimestampThreshold(timestampThreshold);
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.helper.setNonceStore(nonceStore);
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.helper.setDecodeNonce(decodeNonce);
    }

    protected class CustomValidator
    extends UsernameTokenValidator {
        protected CustomValidator() {
        }

        protected void verifyCustomPassword(org.apache.wss4j.dom.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            SubjectCreatingInterceptor.this.setSubject(usernameToken.getName(), usernameToken.getPassword(), false, null, null);
        }

        protected void verifyPlaintextPassword(org.apache.wss4j.dom.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            SubjectCreatingInterceptor.this.setSubject(usernameToken.getName(), usernameToken.getPassword(), false, null, null);
        }

        protected void verifyDigestPassword(org.apache.wss4j.dom.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            if (!SubjectCreatingInterceptor.this.supportDigestPasswords) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
            String user = usernameToken.getName();
            String password = usernameToken.getPassword();
            boolean isHashed = usernameToken.isHashed();
            String nonce = usernameToken.getNonce();
            String createdTime = usernameToken.getCreated();
            SubjectCreatingInterceptor.this.setSubject(user, password, isHashed, nonce, createdTime);
        }

        protected void verifyUnknownPassword(org.apache.wss4j.dom.message.token.UsernameToken usernameToken, RequestData data) throws WSSecurityException {
            SubjectCreatingInterceptor.this.setSubject(usernameToken.getName(), null, false, null, null);
        }
    }
}

