/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.interceptor;

import jakarta.xml.ws.Binding;
import java.util.function.UnaryOperator;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.AbstractTCCLAwarePhaseInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.TCCLAwarePhaseInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.TCCLAwareSoapPhaseInterceptor;

public final class TCCLAwareInterceptorReplacer
implements UnaryOperator<Interceptor<? extends Message>> {
    private final Binding binding;

    public TCCLAwareInterceptorReplacer(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Interceptor<? extends Message> apply(Interceptor<? extends Message> interceptor) {
        return TCCLAwareInterceptorReplacer.shouldReplaceInterceptor(interceptor) ? this.replace((PhaseInterceptor<? extends Message>)((PhaseInterceptor)interceptor)) : interceptor;
    }

    private PhaseInterceptor<? extends Message> replace(PhaseInterceptor<? extends Message> interceptor) {
        if (interceptor instanceof AbstractTCCLAwarePhaseInterceptor) {
            return interceptor;
        }
        if (interceptor instanceof SoapInterceptor) {
            return new TCCLAwareSoapPhaseInterceptor(this.binding, interceptor);
        }
        return new TCCLAwarePhaseInterceptor((PhaseInterceptor<Message>)interceptor);
    }

    private static boolean shouldReplaceInterceptor(Interceptor<? extends Message> interceptor) {
        boolean isApacheCXFSOAPHandlerInterceptor = interceptor instanceof SOAPHandlerInterceptor;
        boolean isNotApacheCXFInterceptor = !interceptor.getClass().getName().startsWith("org.apache.cxf");
        return isApacheCXFSOAPHandlerInterceptor || isNotApacheCXFInterceptor;
    }
}

