/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.javax;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.ws.WebServiceContext;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.javax.finders.EJBFieldFinder;
import org.jboss.wsf.common.javax.finders.EJBMethodFinder;
import org.jboss.wsf.common.javax.finders.InjectionFieldFinder;
import org.jboss.wsf.common.javax.finders.InjectionMethodFinder;
import org.jboss.wsf.common.javax.finders.PostConstructMethodFinder;
import org.jboss.wsf.common.javax.finders.PreDestroyMethodFinder;
import org.jboss.wsf.common.javax.finders.ResourceFieldFinder;
import org.jboss.wsf.common.javax.finders.ResourceMethodFinder;
import org.jboss.wsf.common.reflection.ClassProcessor;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaxAnnotationHelper {
    private static final Logger LOG = Logger.getLogger(JavaxAnnotationHelper.class);
    private static final String POJO_JNDI_PREFIX = "java:comp/env/";
    private static final ClassProcessor<Method> POST_CONSTRUCT_METHOD_FINDER = new PostConstructMethodFinder();
    private static final ClassProcessor<Method> PRE_DESTROY_METHOD_FINDER = new PreDestroyMethodFinder();
    private static final ClassProcessor<Method> RESOURCE_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, false);
    private static final ClassProcessor<Field> RESOURCE_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, false);
    private static final ClassProcessor<Method> EJB_METHOD_FINDER = new EJBMethodFinder();
    private static final ClassProcessor<Field> EJB_FIELD_FINDER = new EJBFieldFinder();
    private static final ClassProcessor<Method> WEB_SERVICE_CONTEXT_METHOD_FINDER = new ResourceMethodFinder(WebServiceContext.class, true);
    private static final ClassProcessor<Field> WEB_SERVICE_CONTEXT_FIELD_FINDER = new ResourceFieldFinder(WebServiceContext.class, true);

    private JavaxAnnotationHelper() {
    }

    public static void injectResources(Object instance, InjectionsMetaData injections) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        if (injections == null) {
            return;
        }
        Context ctx = injections.getContext();
        if (ctx == null) {
            ctx = (Context)new InitialContext().lookup(POJO_JNDI_PREFIX);
        }
        Collection injectionMDs = injections.getInjectionsMetaData(instance.getClass());
        for (InjectionMetaData injectionMD : injectionMDs) {
            JavaxAnnotationHelper.injectDescriptorDrivenInjections(instance, ctx, injectionMD);
        }
        JavaxAnnotationHelper.injectResourceAnnotatedMethods(instance, ctx);
        JavaxAnnotationHelper.injectResourceAnnotatedFields(instance, ctx);
        JavaxAnnotationHelper.injectEJBAnnotatedMethods(instance, ctx);
        JavaxAnnotationHelper.injectEJBAnnotatedFields(instance, ctx);
    }

    private static void injectDescriptorDrivenInjections(Object instance, Context ctx, InjectionMetaData injectionMD) {
        Method method = JavaxAnnotationHelper.getMethod(injectionMD, instance.getClass());
        if (method != null) {
            try {
                JavaxAnnotationHelper.inject(instance, method, injectionMD.getEnvEntryName(), ctx);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject method (descriptor driven injection): " + injectionMD), (Throwable)e);
            }
        } else {
            Field field = JavaxAnnotationHelper.getField(injectionMD, instance.getClass());
            if (field != null) {
                try {
                    JavaxAnnotationHelper.inject(instance, field, injectionMD.getEnvEntryName(), ctx);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot inject field (descriptor driven injection): " + injectionMD), (Throwable)e);
                }
            } else {
                LOG.error((Object)("Cannot find injection target for: " + injectionMD));
            }
        }
    }

    private static void injectResourceAnnotatedFields(Object instance, Context ctx) {
        Collection<Field> resourceAnnotatedFields = RESOURCE_FIELD_FINDER.process(instance.getClass());
        for (Field field : resourceAnnotatedFields) {
            try {
                JavaxAnnotationHelper.inject(instance, field, field.getAnnotation(Resource.class).name(), ctx);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject field annotated with @Resource annotation: " + field), (Throwable)e);
            }
        }
    }

    private static void injectResourceAnnotatedMethods(Object instance, Context ctx) {
        Collection<Method> resourceAnnotatedMethods = RESOURCE_METHOD_FINDER.process(instance.getClass());
        for (Method method : resourceAnnotatedMethods) {
            try {
                JavaxAnnotationHelper.inject(instance, method, method.getAnnotation(Resource.class).name(), ctx);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject method annotated with @Resource annotation: " + method), (Throwable)e);
            }
        }
    }

    private static void injectEJBAnnotatedFields(Object instance, Context ctx) {
        Collection<Field> ejbAnnotatedFields = EJB_FIELD_FINDER.process(instance.getClass());
        for (Field field : ejbAnnotatedFields) {
            try {
                JavaxAnnotationHelper.inject(instance, field, field.getAnnotation(EJB.class).name(), ctx);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject field annotated with @EJB annotation: " + field), (Throwable)e);
            }
        }
    }

    private static void injectEJBAnnotatedMethods(Object instance, Context ctx) {
        Collection<Method> ejbAnnotatedMethods = EJB_METHOD_FINDER.process(instance.getClass());
        for (Method method : ejbAnnotatedMethods) {
            try {
                JavaxAnnotationHelper.inject(instance, method, method.getAnnotation(EJB.class).name(), ctx);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject method annotated with @EJB annotation: " + method), (Throwable)e);
            }
        }
    }

    public static void injectWebServiceContext(Object instance, WebServiceContext ctx) {
        Class<?> instanceClass = instance.getClass();
        Collection<Method> resourceAnnotatedMethods = WEB_SERVICE_CONTEXT_METHOD_FINDER.process(instanceClass);
        for (Method method : resourceAnnotatedMethods) {
            try {
                JavaxAnnotationHelper.invokeMethod(instance, method, new Object[]{ctx});
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject @Resource annotated method: " + method), (Throwable)e);
            }
        }
        Collection<Field> resourceAnnotatedFields = WEB_SERVICE_CONTEXT_FIELD_FINDER.process(instanceClass);
        for (Field field : resourceAnnotatedFields) {
            try {
                JavaxAnnotationHelper.setField(instance, field, ctx);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot inject @Resource annotated field: " + field), (Throwable)e);
            }
        }
    }

    public static void callPostConstructMethod(Object instance) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        Collection<Method> methods = POST_CONSTRUCT_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            LOG.debug((Object)("Calling @PostConstruct annotated method: " + method));
            try {
                JavaxAnnotationHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                LOG.error((Object)("Calling of @PostConstruct annotated method failed: " + method), (Throwable)e);
            }
        }
    }

    public static void callPreDestroyMethod(Object instance) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Object instance cannot be null");
        }
        Collection<Method> methods = PRE_DESTROY_METHOD_FINDER.process(instance.getClass());
        if (methods.size() > 0) {
            Method method = methods.iterator().next();
            LOG.debug((Object)("Calling @PreDestroy annotated method: " + method));
            try {
                JavaxAnnotationHelper.invokeMethod(instance, method, null);
            }
            catch (Exception e) {
                LOG.error((Object)("Calling of @PreDestroy annotated method failed: " + method), (Throwable)e);
            }
        }
    }

    private static void inject(Object instance, Method method, String resourceName, Context ctx) throws Exception {
        String beanName = JavaxAnnotationHelper.convertToBeanName(method.getName());
        Object value = ctx.lookup(JavaxAnnotationHelper.getName(resourceName, beanName));
        LOG.debug((Object)("Injecting method: " + method));
        JavaxAnnotationHelper.invokeMethod(instance, method, new Object[]{value});
    }

    private static void inject(Object instance, Field field, String resourceName, Context ctx) throws Exception {
        String beanName = field.getName();
        Object value = ctx.lookup(JavaxAnnotationHelper.getName(resourceName, beanName));
        LOG.debug((Object)("Injecting field: " + field));
        JavaxAnnotationHelper.setField(instance, field, value);
    }

    private static String convertToBeanName(String methodName) {
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    private static String getName(String resourceName, String beanName) {
        return resourceName.length() > 0 ? resourceName : beanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeMethod(Object instance, Method method, Object[] args) throws Exception {
        boolean accessability = method.isAccessible();
        try {
            method.setAccessible(true);
            method.invoke(instance, args);
        }
        finally {
            method.setAccessible(accessability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setField(Object instance, Field field, Object value) throws Exception {
        boolean accessability = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        finally {
            field.setAccessible(accessability);
        }
    }

    private static Method getMethod(InjectionMetaData injectionMD, Class<?> clazz) {
        Collection result = new InjectionMethodFinder(injectionMD).process(clazz);
        return result.isEmpty() ? null : (Method)result.iterator().next();
    }

    private static Field getField(InjectionMetaData injectionMD, Class<?> clazz) {
        Collection result = new InjectionFieldFinder(injectionMD).process(clazz);
        return result.isEmpty() ? null : (Field)result.iterator().next();
    }
}

