/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class PathWriterTask
extends Task {
    private String pathId;
    private String outputFile;
    private String variables;

    public void execute() throws BuildException {
        Project project = this.getProject();
        Path path = (Path)project.getReference(this.pathId);
        String[] pathElements = path.list();
        try {
            StringBuffer sb = new StringBuffer();
            this.generateContent(sb, pathElements);
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(this.outputFile)));
            out.write(sb.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void generateContent(StringBuffer sb, String[] libs) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<project>\n");
        sb.append("<path id=\"");
        sb.append(this.pathId);
        sb.append("\">");
        for (int i = 0; i < libs.length; ++i) {
            sb.append("<pathelement location=\"");
            sb.append(this.getPath(libs[i]));
            sb.append("\"/>\n");
        }
        sb.append("</path>");
        sb.append("</project>\n");
    }

    private String getPath(String absolutePath) {
        StringTokenizer st = new StringTokenizer(this.variables, ";:, ", false);
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            String value = this.getProject().getProperty(v);
            if (!absolutePath.contains(value)) continue;
            int begin = absolutePath.indexOf(value);
            int end = begin + value.length();
            absolutePath = absolutePath.substring(0, begin) + "${" + v + "}" + absolutePath.substring(end);
        }
        return absolutePath;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }
}

