/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.core.utils.ResourceURL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossWSEntityResolver
extends JBossEntityResolver {
    private static final Logger log = Logger.getLogger(JBossWSEntityResolver.class);

    public JBossWSEntityResolver() {
        JBossWSEntityResolver.registerEntity((String)"urn:jboss:jaxrpc-config:2.0", (String)"schema/jaxrpc-config_2_0.xsd");
        JBossWSEntityResolver.registerEntity((String)"urn:jboss:jaxws-config:2.0", (String)"schema/jaxws-config_2_0.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://java.sun.com/xml/ns/javaee", (String)"schema/javaee_web_services_1_2.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://www.w3.org/2005/08/addressing", (String)"schema/ws-addr.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://schemas.xmlsoap.org/ws/2004/08/eventing", (String)"eventing.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://www.w3.org/2002/06/soap-encoding", (String)"soap-encoding_200206.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://schemas.xmlsoap.org/soap/encoding/", (String)"soap-encoding_1_1.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", (String)"j2ee_web_services_client_1_1.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", (String)"j2ee_web_services_1_1.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", (String)"j2ee_jaxrpc_mapping_1_1.xsd");
        JBossWSEntityResolver.registerEntity((String)"http://ws-i.org/profiles/basic/1.1/swaref.xsd", (String)"schema/swaref.xsd");
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        }
        if ((inputSource = super.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.resolveSystemIDAsURL(systemId, log.isTraceEnabled());
        }
        if (inputSource == null) {
            log.debug((Object)("Cannot resolve entity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        }
        return inputSource;
    }

    protected InputSource resolveSystemIDAsURL(String id, boolean trace) {
        InputSource inputSource;
        block11: {
            if (id == null) {
                return null;
            }
            if (trace) {
                log.trace((Object)("resolveIDAsResourceURL, id=" + id));
            }
            inputSource = null;
            try {
                InputStream ins;
                URL url;
                if (trace) {
                    log.trace((Object)"Trying to resolve id as a URL");
                }
                if (!(url = new URL(id)).getProtocol().equalsIgnoreCase("file")) {
                    log.warn((Object)("Trying to resolve id as a non-file URL: " + id));
                }
                if ((ins = new ResourceURL(url).openStream()) != null) {
                    inputSource = new InputSource(ins);
                    inputSource.setSystemId(id);
                } else {
                    log.warn((Object)("Cannot load id as URL: " + id));
                }
                if (trace) {
                    log.trace((Object)"Resolved id as a URL");
                }
            }
            catch (MalformedURLException ignored) {
                if (trace) {
                    log.trace((Object)("id is not a url: " + id), (Throwable)ignored);
                }
            }
            catch (IOException e) {
                if (!trace) break block11;
                log.trace((Object)("Failed to obtain URL.InputStream from id: " + id), (Throwable)e);
            }
        }
        return inputSource;
    }
}

