/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import org.jboss.ws.core.utils.JarUrlConnection;

public class ResourceURL {
    private URL targetURL;
    private boolean isMacOs = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public ResourceURL(URL targetURL) {
        this.targetURL = targetURL;
    }

    public URL getTargetURL() {
        return this.targetURL;
    }

    public InputStream openStream() throws IOException {
        boolean isJarUrl = "jar".equals(this.targetURL.getProtocol());
        URL tmpTargetURL = this.targetURL;
        if (this.isMacOs) {
            tmpTargetURL = new URL(this.targetURL.getProtocol(), this.targetURL.getHost(), this.targetURL.getPort(), URLEncoder.encode(this.targetURL.getFile(), "UTF-8"));
        }
        return isJarUrl ? new JarUrlConnection(tmpTargetURL).getInputStream() : tmpTargetURL.openStream();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceURL)) {
            return false;
        }
        ResourceURL other = (ResourceURL)obj;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        return this.targetURL.toString();
    }
}

