/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.common.management.AbstractServerConfigMBean;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.StackConfig;
import org.jboss.wsf.spi.management.StackConfigFactory;

public abstract class AbstractServerConfig
implements AbstractServerConfigMBean,
ServerConfig {
    private static final Logger log = Logger.getLogger(AbstractServerConfig.class);
    protected static final ObjectName OBJECT_NAME_SERVER_CONFIG = ObjectNameFactory.create("jboss.system:type=ServerConfig");
    private MBeanServer mbeanServer;
    private String webServiceHost = "jbossws.undefined.host";
    private int webServicePort;
    private int webServiceSecurePort;
    private boolean modifySOAPAddress;
    protected StackConfig stackConfig;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            log.debug((Object)"Using undefined host: jbossws.undefined.host");
            host = "jbossws.undefined.host";
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            log.debug((Object)("Using local host: " + localHost.getHostName()));
            host = localHost.getHostName();
        }
        this.webServiceHost = host;
    }

    public void setWebServicePort(int port) {
        this.webServicePort = port;
    }

    public void setWebServiceSecurePort(int port) {
        this.webServiceSecurePort = port;
    }

    public boolean isModifySOAPAddress() {
        return this.modifySOAPAddress;
    }

    public void setModifySOAPAddress(boolean modify) {
        this.modifySOAPAddress = modify;
    }

    public int getWebServicePort() {
        int localPort;
        if (this.webServicePort <= 0) {
            this.webServicePort = this.getConnectorPort("HTTP/1.1", false);
        }
        if ((localPort = this.webServicePort) <= 0) {
            log.warn((Object)"Unable to calculate 'WebServicePort', using default '8080'");
            localPort = 8080;
        }
        return localPort;
    }

    public int getWebServiceSecurePort() {
        int localPort;
        if (this.webServiceSecurePort <= 0) {
            this.webServiceSecurePort = this.getConnectorPort("HTTP/1.1", true);
        }
        if ((localPort = this.webServiceSecurePort) <= 0) {
            log.warn((Object)"Unable to calculate 'WebServiceSecurePort', using default '8443'");
            localPort = 8443;
        }
        return localPort;
    }

    public void create() throws Exception {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.stackConfig = ((StackConfigFactory)spiProvider.getSPI(StackConfigFactory.class)).getStackConfig();
        log.info((Object)this.getImplementationTitle());
        log.info((Object)this.getImplementationVersion());
        this.getMbeanServer().registerMBean(this, AbstractServerConfigMBean.OBJECT_NAME);
    }

    public void destroy() throws Exception {
        this.getMbeanServer().unregisterMBean(AbstractServerConfigMBean.OBJECT_NAME);
    }

    private int getConnectorPort(String protocol, boolean secure) {
        int port = -1;
        try {
            ObjectName connectors = new ObjectName("jboss.web:type=Connector,*");
            Set<ObjectName> connectorNames = this.getMbeanServer().queryNames(connectors, null);
            Iterator<ObjectName> i$ = connectorNames.iterator();
            while (i$.hasNext()) {
                ObjectName current;
                ObjectName currentName = current = i$.next();
                try {
                    int connectorPort = (Integer)this.getMbeanServer().getAttribute(currentName, "port");
                    boolean connectorSecure = (Boolean)this.getMbeanServer().getAttribute(currentName, "secure");
                    String connectorProtocol = (String)this.getMbeanServer().getAttribute(currentName, "protocol");
                    if (!protocol.equals(connectorProtocol) || secure != connectorSecure) continue;
                    if (port > -1) {
                        log.warn((Object)("Found multiple connectors for protocol='" + protocol + "' and secure='" + secure + "', using first port found '" + port + "'"));
                        continue;
                    }
                    port = connectorPort;
                }
                catch (AttributeNotFoundException ignored) {}
            }
            return port;
        }
        catch (JMException e) {
            return -1;
        }
    }

    public String getImplementationTitle() {
        return this.stackConfig.getImplementationTitle();
    }

    public String getImplementationVersion() {
        return this.stackConfig.getImplementationVersion();
    }
}

