/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.common.concurrent.CopyJob;
import org.jboss.wsf.test.JBossWSTestHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBossWSTest
extends TestCase {
    protected static Logger log = Logger.getLogger((String)JBossWSTest.class.getName());

    public JBossWSTest() {
    }

    public JBossWSTest(String name) {
        super(name);
    }

    public static void executeCommand(String command) throws IOException {
        JBossWSTest.executeCommand(command, null, null, null);
    }

    public static void executeCommand(String command, String message) throws IOException {
        JBossWSTest.executeCommand(command, null, message, null);
    }

    public static void executeCommand(String command, OutputStream os) throws IOException {
        JBossWSTest.executeCommand(command, os, null, null);
    }

    public static void executeCommand(String command, OutputStream os, String message) throws IOException {
        JBossWSTest.executeCommand(command, os, message, null);
    }

    public static void executeCommand(String command, OutputStream os, String message, Map<String, String> env) throws IOException {
        if (command == null) {
            throw new NullPointerException("Command cannot be null");
        }
        System.out.println("Executing command: " + command);
        log.debug((Object)("Executing command: " + command));
        StringTokenizer st = new StringTokenizer(command, " \t\r");
        LinkedList<String> tokenizedCommand = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            tokenizedCommand.add(st.nextToken());
        }
        try {
            JBossWSTest.executeCommand(tokenizedCommand, os, message, env);
        }
        catch (IOException e) {
            log.warn((Object)"Make sure there are no whitespaces in command paths", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeCommand(List<String> command, OutputStream os, String message, Map<String, String> env) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        if (env != null) {
            for (String variable : env.keySet()) {
                pb.environment().put(variable, env.get(variable));
            }
        }
        Process p = pb.start();
        CopyJob inputStreamJob = new CopyJob(p.getInputStream(), os == null ? System.out : os);
        CopyJob errorStreamJob = new CopyJob(p.getErrorStream(), System.err);
        System.out.println("Process input stream:");
        System.err.println("Process error stream:");
        new Thread(inputStreamJob).start();
        new Thread(errorStreamJob).start();
        try {
            int statusCode = p.waitFor();
            String fallbackMessage = "Process did exit with status " + statusCode;
            JBossWSTest.assertTrue((String)(message != null ? message : fallbackMessage), (statusCode == 0 ? 1 : 0) != 0);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.err);
        }
        finally {
            inputStreamJob.kill();
            errorStreamJob.kill();
            p.destroy();
        }
    }

    public static MBeanServerConnection getServer() throws NamingException {
        return JBossWSTestHelper.getServer();
    }

    public static boolean isTargetJBoss5() {
        return JBossWSTestHelper.isTargetJBoss5();
    }

    public static boolean isTargetJBoss51() {
        return JBossWSTestHelper.isTargetJBoss51();
    }

    public static boolean isTargetJBoss52() {
        return JBossWSTestHelper.isTargetJBoss52();
    }

    public static boolean isTargetJBoss50() {
        return JBossWSTestHelper.isTargetJBoss50();
    }

    public static boolean isTargetJBoss6() {
        return JBossWSTestHelper.isTargetJBoss6();
    }

    public static boolean isTargetJBoss61() {
        return JBossWSTestHelper.isTargetJBoss61();
    }

    public static boolean isTargetJBoss60() {
        return JBossWSTestHelper.isTargetJBoss60();
    }

    public static boolean isIntegrationNative() {
        return JBossWSTestHelper.isIntegrationNative();
    }

    public static boolean isIntegrationMetro() {
        return JBossWSTestHelper.isIntegrationMetro();
    }

    public static boolean isIntegrationCXF() {
        return JBossWSTestHelper.isIntegrationCXF();
    }

    public static void deploy(String archive) throws Exception {
        JBossWSTestHelper.deploy(archive);
    }

    public static void undeploy(String archive) throws Exception {
        JBossWSTestHelper.undeploy(archive);
    }

    public static String getServerHost() {
        return JBossWSTestHelper.getServerHost();
    }

    public static File getArchiveFile(String archive) {
        return JBossWSTestHelper.getArchiveFile(archive);
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveURL(archive);
    }

    public static File getResourceFile(String resource) {
        return JBossWSTestHelper.getResourceFile(resource);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceURL(resource);
    }

    public static File createResourceFile(String filename) {
        File resDir = new File(JBossWSTestHelper.getTestResourcesDir());
        return new File(resDir.getAbsolutePath() + File.separator + filename);
    }

    public static File createResourceFile(File parent, String filename) {
        return new File(parent, filename);
    }

    protected static InitialContext getInitialContext(String clientName) throws NamingException {
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming.client");
        env.put("j2ee.clientName", clientName);
        return new InitialContext(env);
    }

    protected static InitialContext getInitialContext() throws NamingException {
        return JBossWSTest.getInitialContext("jbossws-client");
    }

    public static void assertEquals(Element expElement, Element wasElement, boolean ignoreWhitespace) {
        JBossWSTest.normalizeWhitespace(expElement, ignoreWhitespace);
        JBossWSTest.normalizeWhitespace(wasElement, ignoreWhitespace);
        String expStr = DOMWriter.printNode(expElement, false);
        String wasStr = DOMWriter.printNode(wasElement, false);
        if (!expStr.equals(wasStr)) {
            System.out.println("\nExp: " + expStr + "\nWas: " + wasStr);
        }
        JBossWSTest.assertEquals((String)expStr, (String)wasStr);
    }

    public static void assertEquals(Element expElement, Element wasElement) {
        JBossWSTest.assertEquals(expElement, wasElement, false);
    }

    public static void assertEquals(Object exp, Object was) {
        if (exp instanceof Object[] && was instanceof Object[]) {
            JBossWSTest.assertEqualsArray((Object[])exp, (Object[])was);
        } else if (exp instanceof byte[] && was instanceof byte[]) {
            JBossWSTest.assertEqualsArray((byte[])exp, (byte[])was);
        } else if (exp instanceof boolean[] && was instanceof boolean[]) {
            JBossWSTest.assertEqualsArray((boolean[])exp, (boolean[])was);
        } else if (exp instanceof short[] && was instanceof short[]) {
            JBossWSTest.assertEqualsArray((short[])exp, (short[])was);
        } else if (exp instanceof int[] && was instanceof int[]) {
            JBossWSTest.assertEqualsArray((int[])exp, (int[])was);
        } else if (exp instanceof long[] && was instanceof long[]) {
            JBossWSTest.assertEqualsArray((long[])exp, (long[])was);
        } else if (exp instanceof float[] && was instanceof float[]) {
            JBossWSTest.assertEqualsArray((float[])exp, (float[])was);
        } else if (exp instanceof double[] && was instanceof double[]) {
            JBossWSTest.assertEqualsArray((double[])exp, (double[])was);
        } else {
            TestCase.assertEquals((Object)exp, (Object)was);
        }
    }

    private static void assertEqualsArray(Object[] exp, Object[] was) {
        if (exp == null && was == null) {
            return;
        }
        if (exp != null && was != null) {
            if (exp.length != was.length) {
                JBossWSTest.fail((String)("Expected <" + exp.length + "> array items, but was <" + was.length + ">"));
            } else {
                for (int i = 0; i < exp.length; ++i) {
                    Object compExp = exp[i];
                    Object compWas = was[i];
                    JBossWSTest.assertEquals(compExp, compWas);
                }
            }
        } else if (exp == null) {
            JBossWSTest.fail((String)("Expected a null array, but was: " + Arrays.asList(was)));
        } else if (was == null) {
            JBossWSTest.fail((String)("Expected " + Arrays.asList(exp) + ", but was: null"));
        }
    }

    private static void assertEqualsArray(byte[] exp, byte[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(boolean[] exp, boolean[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(short[] exp, short[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(int[] exp, int[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(long[] exp, long[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(float[] exp, float[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(double[] exp, double[] was) {
        JBossWSTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void normalizeWhitespace(Element element, boolean ignoreWhitespace) {
        boolean hasChildElement = false;
        ArrayList<Node> toDetach = new ArrayList<Node>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeValue;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 3 && (nodeValue = node.getNodeValue()).trim().length() == 0) {
                toDetach.add(node);
            }
            if (node.getNodeType() != 1) continue;
            JBossWSTest.normalizeWhitespace((Element)node, ignoreWhitespace);
            hasChildElement = true;
        }
        if (hasChildElement || ignoreWhitespace) {
            for (Node whiteSpaceNode : toDetach) {
                element.removeChild(whiteSpaceNode);
            }
        }
    }
}

